// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of private link service IP configuration.
 */
@Fluent
public final class PrivateLinkServiceIpConfigurationPropertiesInner
    implements JsonSerializable<PrivateLinkServiceIpConfigurationPropertiesInner> {
    /*
     * The private IP address of the IP configuration.
     */
    private String privateIpAddress;

    /*
     * The private IP address allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * The reference to the subnet resource.
     */
    private SubnetInner subnet;

    /*
     * Whether the ip configuration is primary or not.
     */
    private Boolean primary;

    /*
     * The provisioning state of the private link service IP configuration resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    private IpVersion privateIpAddressVersion;

    /**
     * Creates an instance of PrivateLinkServiceIpConfigurationPropertiesInner class.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner() {
    }

    /**
     * Get the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the PrivateLinkServiceIpConfigurationPropertiesInner object itself.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the PrivateLinkServiceIpConfigurationPropertiesInner object itself.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the subnet property: The reference to the subnet resource.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the PrivateLinkServiceIpConfigurationPropertiesInner object itself.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the primary property: Whether the ip configuration is primary or not.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Whether the ip configuration is primary or not.
     * 
     * @param primary the primary value to set.
     * @return the PrivateLinkServiceIpConfigurationPropertiesInner object itself.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the private link service IP configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateIpAddressVersion property: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     * 
     * @return the privateIpAddressVersion value.
     */
    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    /**
     * Set the privateIpAddressVersion property: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     * 
     * @param privateIpAddressVersion the privateIpAddressVersion value to set.
     * @return the PrivateLinkServiceIpConfigurationPropertiesInner object itself.
     */
    public PrivateLinkServiceIpConfigurationPropertiesInner
        withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeStringField("privateIPAddressVersion",
            this.privateIpAddressVersion == null ? null : this.privateIpAddressVersion.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkServiceIpConfigurationPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkServiceIpConfigurationPropertiesInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkServiceIpConfigurationPropertiesInner.
     */
    public static PrivateLinkServiceIpConfigurationPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkServiceIpConfigurationPropertiesInner deserializedPrivateLinkServiceIpConfigurationPropertiesInner
                = new PrivateLinkServiceIpConfigurationPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateIPAddress".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAddress = reader.getString();
                } else if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.subnet = SubnetInner.fromJson(reader);
                } else if ("primary".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedPrivateLinkServiceIpConfigurationPropertiesInner.privateIpAddressVersion
                        = IpVersion.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkServiceIpConfigurationPropertiesInner;
        });
    }
}
