// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cross tenant scopes.
 */
@Immutable
public final class CrossTenantScopes implements JsonSerializable<CrossTenantScopes> {
    /*
     * Tenant ID.
     */
    private String tenantId;

    /*
     * List of management groups.
     */
    private List<String> managementGroups;

    /*
     * List of subscriptions.
     */
    private List<String> subscriptions;

    /**
     * Creates an instance of CrossTenantScopes class.
     */
    public CrossTenantScopes() {
    }

    /**
     * Get the tenantId property: Tenant ID.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the managementGroups property: List of management groups.
     * 
     * @return the managementGroups value.
     */
    public List<String> managementGroups() {
        return this.managementGroups;
    }

    /**
     * Get the subscriptions property: List of subscriptions.
     * 
     * @return the subscriptions value.
     */
    public List<String> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CrossTenantScopes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CrossTenantScopes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CrossTenantScopes.
     */
    public static CrossTenantScopes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CrossTenantScopes deserializedCrossTenantScopes = new CrossTenantScopes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedCrossTenantScopes.tenantId = reader.getString();
                } else if ("managementGroups".equals(fieldName)) {
                    List<String> managementGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedCrossTenantScopes.managementGroups = managementGroups;
                } else if ("subscriptions".equals(fieldName)) {
                    List<String> subscriptions = reader.readArray(reader1 -> reader1.getString());
                    deserializedCrossTenantScopes.subscriptions = subscriptions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCrossTenantScopes;
        });
    }
}
