// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.CustomIpPrefixInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListCustomIpPrefixes API service call.
 */
@Fluent
public final class CustomIpPrefixListResult implements JsonSerializable<CustomIpPrefixListResult> {
    /*
     * A list of Custom IP prefixes that exists in a resource group.
     */
    private List<CustomIpPrefixInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of CustomIpPrefixListResult class.
     */
    public CustomIpPrefixListResult() {
    }

    /**
     * Get the value property: A list of Custom IP prefixes that exists in a resource group.
     * 
     * @return the value value.
     */
    public List<CustomIpPrefixInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of Custom IP prefixes that exists in a resource group.
     * 
     * @param value the value value to set.
     * @return the CustomIpPrefixListResult object itself.
     */
    public CustomIpPrefixListResult withValue(List<CustomIpPrefixInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CustomIpPrefixListResult object itself.
     */
    public CustomIpPrefixListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomIpPrefixListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomIpPrefixListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomIpPrefixListResult.
     */
    public static CustomIpPrefixListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomIpPrefixListResult deserializedCustomIpPrefixListResult = new CustomIpPrefixListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CustomIpPrefixInner> value
                        = reader.readArray(reader1 -> CustomIpPrefixInner.fromJson(reader1));
                    deserializedCustomIpPrefixListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCustomIpPrefixListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomIpPrefixListResult;
        });
    }
}
