// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * List of properties of the device.
 */
@Fluent
public final class DeviceProperties implements JsonSerializable<DeviceProperties> {
    /*
     * Name of the device Vendor.
     */
    private String deviceVendor;

    /*
     * Model of the device.
     */
    private String deviceModel;

    /*
     * Link speed.
     */
    private Integer linkSpeedInMbps;

    /**
     * Creates an instance of DeviceProperties class.
     */
    public DeviceProperties() {
    }

    /**
     * Get the deviceVendor property: Name of the device Vendor.
     * 
     * @return the deviceVendor value.
     */
    public String deviceVendor() {
        return this.deviceVendor;
    }

    /**
     * Set the deviceVendor property: Name of the device Vendor.
     * 
     * @param deviceVendor the deviceVendor value to set.
     * @return the DeviceProperties object itself.
     */
    public DeviceProperties withDeviceVendor(String deviceVendor) {
        this.deviceVendor = deviceVendor;
        return this;
    }

    /**
     * Get the deviceModel property: Model of the device.
     * 
     * @return the deviceModel value.
     */
    public String deviceModel() {
        return this.deviceModel;
    }

    /**
     * Set the deviceModel property: Model of the device.
     * 
     * @param deviceModel the deviceModel value to set.
     * @return the DeviceProperties object itself.
     */
    public DeviceProperties withDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    /**
     * Get the linkSpeedInMbps property: Link speed.
     * 
     * @return the linkSpeedInMbps value.
     */
    public Integer linkSpeedInMbps() {
        return this.linkSpeedInMbps;
    }

    /**
     * Set the linkSpeedInMbps property: Link speed.
     * 
     * @param linkSpeedInMbps the linkSpeedInMbps value to set.
     * @return the DeviceProperties object itself.
     */
    public DeviceProperties withLinkSpeedInMbps(Integer linkSpeedInMbps) {
        this.linkSpeedInMbps = linkSpeedInMbps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceVendor", this.deviceVendor);
        jsonWriter.writeStringField("deviceModel", this.deviceModel);
        jsonWriter.writeNumberField("linkSpeedInMbps", this.linkSpeedInMbps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeviceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeviceProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeviceProperties.
     */
    public static DeviceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeviceProperties deserializedDeviceProperties = new DeviceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deviceVendor".equals(fieldName)) {
                    deserializedDeviceProperties.deviceVendor = reader.getString();
                } else if ("deviceModel".equals(fieldName)) {
                    deserializedDeviceProperties.deviceModel = reader.getString();
                } else if ("linkSpeedInMbps".equals(fieldName)) {
                    deserializedDeviceProperties.linkSpeedInMbps = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeviceProperties;
        });
    }
}
