// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpamPoolInner;
import java.io.IOException;
import java.util.List;

/**
 * List of IpamPool.
 */
@Fluent
public final class IpamPoolList implements JsonSerializable<IpamPoolList> {
    /*
     * The value property.
     */
    private List<IpamPoolInner> value;

    /*
     * The link used to get the next page of operations.
     */
    private String nextLink;

    /**
     * Creates an instance of IpamPoolList class.
     */
    public IpamPoolList() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<IpamPoolInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the IpamPoolList object itself.
     */
    public IpamPoolList withValue(List<IpamPoolInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link used to get the next page of operations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of operations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the IpamPoolList object itself.
     */
    public IpamPoolList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpamPoolList.
     */
    public static IpamPoolList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolList deserializedIpamPoolList = new IpamPoolList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<IpamPoolInner> value = reader.readArray(reader1 -> IpamPoolInner.fromJson(reader1));
                    deserializedIpamPoolList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedIpamPoolList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolList;
        });
    }
}
