// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Represents the IpamPool update API request interface.
 */
@Fluent
public final class IpamPoolUpdate implements JsonSerializable<IpamPoolUpdate> {
    /*
     * Dictionary of <string>
     */
    private Map<String, String> tags;

    /*
     * Represents the IpamPool update properties.
     */
    private IpamPoolUpdateProperties properties;

    /**
     * Creates an instance of IpamPoolUpdate class.
     */
    public IpamPoolUpdate() {
    }

    /**
     * Get the tags property: Dictionary of &lt;string&gt;.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Dictionary of &lt;string&gt;.
     * 
     * @param tags the tags value to set.
     * @return the IpamPoolUpdate object itself.
     */
    public IpamPoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: Represents the IpamPool update properties.
     * 
     * @return the properties value.
     */
    public IpamPoolUpdateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents the IpamPool update properties.
     * 
     * @param properties the properties value to set.
     * @return the IpamPoolUpdate object itself.
     */
    public IpamPoolUpdate withProperties(IpamPoolUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpamPoolUpdate.
     */
    public static IpamPoolUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolUpdate deserializedIpamPoolUpdate = new IpamPoolUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpamPoolUpdate.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedIpamPoolUpdate.properties = IpamPoolUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolUpdate;
        });
    }
}
