// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of static CIDR resource.
 */
@Fluent
public final class StaticCidrProperties implements JsonSerializable<StaticCidrProperties> {
    /*
     * The description property.
     */
    private String description;

    /*
     * Number of IP addresses to allocate for a static CIDR resource. The IP addresses will be assigned based on
     * IpamPools available space.
     */
    private String numberOfIpAddressesToAllocate;

    /*
     * List of IP address prefixes of the resource.
     */
    private List<String> addressPrefixes;

    /*
     * Total number of IP addresses allocated for the static CIDR resource.
     */
    private String totalNumberOfIpAddresses;

    /*
     * Provisioning states of a resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of StaticCidrProperties class.
     */
    public StaticCidrProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the StaticCidrProperties object itself.
     */
    public StaticCidrProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the numberOfIpAddressesToAllocate property: Number of IP addresses to allocate for a static CIDR resource.
     * The IP addresses will be assigned based on IpamPools available space.
     * 
     * @return the numberOfIpAddressesToAllocate value.
     */
    public String numberOfIpAddressesToAllocate() {
        return this.numberOfIpAddressesToAllocate;
    }

    /**
     * Set the numberOfIpAddressesToAllocate property: Number of IP addresses to allocate for a static CIDR resource.
     * The IP addresses will be assigned based on IpamPools available space.
     * 
     * @param numberOfIpAddressesToAllocate the numberOfIpAddressesToAllocate value to set.
     * @return the StaticCidrProperties object itself.
     */
    public StaticCidrProperties withNumberOfIpAddressesToAllocate(String numberOfIpAddressesToAllocate) {
        this.numberOfIpAddressesToAllocate = numberOfIpAddressesToAllocate;
        return this;
    }

    /**
     * Get the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the StaticCidrProperties object itself.
     */
    public StaticCidrProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the totalNumberOfIpAddresses property: Total number of IP addresses allocated for the static CIDR resource.
     * 
     * @return the totalNumberOfIpAddresses value.
     */
    public String totalNumberOfIpAddresses() {
        return this.totalNumberOfIpAddresses;
    }

    /**
     * Get the provisioningState property: Provisioning states of a resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning states of a resource.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the StaticCidrProperties object itself.
     */
    public StaticCidrProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("numberOfIPAddressesToAllocate", this.numberOfIpAddressesToAllocate);
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticCidrProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticCidrProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticCidrProperties.
     */
    public static StaticCidrProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticCidrProperties deserializedStaticCidrProperties = new StaticCidrProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedStaticCidrProperties.description = reader.getString();
                } else if ("numberOfIPAddressesToAllocate".equals(fieldName)) {
                    deserializedStaticCidrProperties.numberOfIpAddressesToAllocate = reader.getString();
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedStaticCidrProperties.addressPrefixes = addressPrefixes;
                } else if ("totalNumberOfIPAddresses".equals(fieldName)) {
                    deserializedStaticCidrProperties.totalNumberOfIpAddresses = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedStaticCidrProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticCidrProperties;
        });
    }
}
