// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network.
 */
@Fluent
public final class VirtualNetworkPeeringListResult implements JsonSerializable<VirtualNetworkPeeringListResult> {
    /*
     * The peerings in a virtual network.
     */
    private List<VirtualNetworkPeeringInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualNetworkPeeringListResult class.
     */
    public VirtualNetworkPeeringListResult() {
    }

    /**
     * Get the value property: The peerings in a virtual network.
     * 
     * @return the value value.
     */
    public List<VirtualNetworkPeeringInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The peerings in a virtual network.
     * 
     * @param value the value value to set.
     * @return the VirtualNetworkPeeringListResult object itself.
     */
    public VirtualNetworkPeeringListResult withValue(List<VirtualNetworkPeeringInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualNetworkPeeringListResult object itself.
     */
    public VirtualNetworkPeeringListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkPeeringListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkPeeringListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkPeeringListResult.
     */
    public static VirtualNetworkPeeringListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkPeeringListResult deserializedVirtualNetworkPeeringListResult
                = new VirtualNetworkPeeringListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualNetworkPeeringInner> value
                        = reader.readArray(reader1 -> VirtualNetworkPeeringInner.fromJson(reader1));
                    deserializedVirtualNetworkPeeringListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualNetworkPeeringListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkPeeringListResult;
        });
    }
}
