/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayConnectionDraining;
import com.azure.resourcemanager.network.models.ApplicationGatewayCookieBasedAffinity;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayBackendHttpSettingsPropertiesFormat
implements JsonSerializable<ApplicationGatewayBackendHttpSettingsPropertiesFormat> {
    private Integer port;
    private ApplicationGatewayProtocol protocol;
    private ApplicationGatewayCookieBasedAffinity cookieBasedAffinity;
    private Integer requestTimeout;
    private SubResource probe;
    private List<SubResource> authenticationCertificates;
    private List<SubResource> trustedRootCertificates;
    private ApplicationGatewayConnectionDraining connectionDraining;
    private String hostname;
    private Boolean pickHostnameFromBackendAddress;
    private String affinityCookieName;
    private Boolean probeEnabled;
    private String path;
    private ProvisioningState provisioningState;

    public Integer port() {
        return this.port;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ApplicationGatewayCookieBasedAffinity cookieBasedAffinity() {
        return this.cookieBasedAffinity;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity cookieBasedAffinity) {
        this.cookieBasedAffinity = cookieBasedAffinity;
        return this;
    }

    public Integer requestTimeout() {
        return this.requestTimeout;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public SubResource probe() {
        return this.probe;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    public List<SubResource> authenticationCertificates() {
        return this.authenticationCertificates;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withAuthenticationCertificates(List<SubResource> authenticationCertificates) {
        this.authenticationCertificates = authenticationCertificates;
        return this;
    }

    public List<SubResource> trustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    public ApplicationGatewayConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withConnectionDraining(ApplicationGatewayConnectionDraining connectionDraining) {
        this.connectionDraining = connectionDraining;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Boolean pickHostnameFromBackendAddress() {
        return this.pickHostnameFromBackendAddress;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withPickHostnameFromBackendAddress(Boolean pickHostnameFromBackendAddress) {
        this.pickHostnameFromBackendAddress = pickHostnameFromBackendAddress;
        return this;
    }

    public String affinityCookieName() {
        return this.affinityCookieName;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withAffinityCookieName(String affinityCookieName) {
        this.affinityCookieName = affinityCookieName;
        return this;
    }

    public Boolean probeEnabled() {
        return this.probeEnabled;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withProbeEnabled(Boolean probeEnabled) {
        this.probeEnabled = probeEnabled;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApplicationGatewayBackendHttpSettingsPropertiesFormat withPath(String path) {
        this.path = path;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.connectionDraining() != null) {
            this.connectionDraining().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("cookieBasedAffinity", this.cookieBasedAffinity == null ? null : this.cookieBasedAffinity.toString());
        jsonWriter.writeNumberField("requestTimeout", (Number)this.requestTimeout);
        jsonWriter.writeJsonField("probe", (JsonSerializable)this.probe);
        jsonWriter.writeArrayField("authenticationCertificates", this.authenticationCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("trustedRootCertificates", this.trustedRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("connectionDraining", (JsonSerializable)this.connectionDraining);
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeBooleanField("pickHostNameFromBackendAddress", this.pickHostnameFromBackendAddress);
        jsonWriter.writeStringField("affinityCookieName", this.affinityCookieName);
        jsonWriter.writeBooleanField("probeEnabled", this.probeEnabled);
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayBackendHttpSettingsPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayBackendHttpSettingsPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHttpSettingsPropertiesFormat deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.protocol = ApplicationGatewayProtocol.fromString(reader.getString());
                    continue;
                }
                if ("cookieBasedAffinity".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.cookieBasedAffinity = ApplicationGatewayCookieBasedAffinity.fromString(reader.getString());
                    continue;
                }
                if ("requestTimeout".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.requestTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probe".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.probe = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("authenticationCertificates".equals(fieldName)) {
                    List authenticationCertificates;
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.authenticationCertificates = authenticationCertificates = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("trustedRootCertificates".equals(fieldName)) {
                    List trustedRootCertificates;
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.trustedRootCertificates = trustedRootCertificates = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("connectionDraining".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.connectionDraining = ApplicationGatewayConnectionDraining.fromJson(reader);
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.hostname = reader.getString();
                    continue;
                }
                if ("pickHostNameFromBackendAddress".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.pickHostnameFromBackendAddress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("affinityCookieName".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.affinityCookieName = reader.getString();
                    continue;
                }
                if ("probeEnabled".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.probeEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.path = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayBackendHttpSettingsPropertiesFormat;
        });
    }
}

