/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.P2SVpnGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import com.azure.resourcemanager.network.models.AadAuthenticationParameters;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.RadiusServer;
import com.azure.resourcemanager.network.models.VpnAuthenticationType;
import com.azure.resourcemanager.network.models.VpnGatewayTunnelingProtocol;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusClientRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusServerRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRevokedCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRootCertificate;
import java.io.IOException;
import java.util.List;

public final class VpnServerConfigurationProperties
implements JsonSerializable<VpnServerConfigurationProperties> {
    private String name;
    private List<VpnGatewayTunnelingProtocol> vpnProtocols;
    private List<VpnAuthenticationType> vpnAuthenticationTypes;
    private List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates;
    private List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates;
    private List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates;
    private List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates;
    private List<IpsecPolicy> vpnClientIpsecPolicies;
    private String radiusServerAddress;
    private String radiusServerSecret;
    private List<RadiusServer> radiusServers;
    private AadAuthenticationParameters aadAuthenticationParameters;
    private String provisioningState;
    private List<P2SVpnGatewayInner> p2SVpnGateways;
    private List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups;
    private String etag;

    public String name() {
        return this.name;
    }

    public VpnServerConfigurationProperties withName(String name) {
        this.name = name;
        return this;
    }

    public List<VpnGatewayTunnelingProtocol> vpnProtocols() {
        return this.vpnProtocols;
    }

    public VpnServerConfigurationProperties withVpnProtocols(List<VpnGatewayTunnelingProtocol> vpnProtocols) {
        this.vpnProtocols = vpnProtocols;
        return this;
    }

    public List<VpnAuthenticationType> vpnAuthenticationTypes() {
        return this.vpnAuthenticationTypes;
    }

    public VpnServerConfigurationProperties withVpnAuthenticationTypes(List<VpnAuthenticationType> vpnAuthenticationTypes) {
        this.vpnAuthenticationTypes = vpnAuthenticationTypes;
        return this;
    }

    public List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates() {
        return this.vpnClientRootCertificates;
    }

    public VpnServerConfigurationProperties withVpnClientRootCertificates(List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates) {
        this.vpnClientRootCertificates = vpnClientRootCertificates;
        return this;
    }

    public List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates() {
        return this.vpnClientRevokedCertificates;
    }

    public VpnServerConfigurationProperties withVpnClientRevokedCertificates(List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates) {
        this.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
        return this;
    }

    public List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates() {
        return this.radiusServerRootCertificates;
    }

    public VpnServerConfigurationProperties withRadiusServerRootCertificates(List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates) {
        this.radiusServerRootCertificates = radiusServerRootCertificates;
        return this;
    }

    public List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates() {
        return this.radiusClientRootCertificates;
    }

    public VpnServerConfigurationProperties withRadiusClientRootCertificates(List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates) {
        this.radiusClientRootCertificates = radiusClientRootCertificates;
        return this;
    }

    public List<IpsecPolicy> vpnClientIpsecPolicies() {
        return this.vpnClientIpsecPolicies;
    }

    public VpnServerConfigurationProperties withVpnClientIpsecPolicies(List<IpsecPolicy> vpnClientIpsecPolicies) {
        this.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
        return this;
    }

    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    public VpnServerConfigurationProperties withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    public VpnServerConfigurationProperties withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    public List<RadiusServer> radiusServers() {
        return this.radiusServers;
    }

    public VpnServerConfigurationProperties withRadiusServers(List<RadiusServer> radiusServers) {
        this.radiusServers = radiusServers;
        return this;
    }

    public AadAuthenticationParameters aadAuthenticationParameters() {
        return this.aadAuthenticationParameters;
    }

    public VpnServerConfigurationProperties withAadAuthenticationParameters(AadAuthenticationParameters aadAuthenticationParameters) {
        this.aadAuthenticationParameters = aadAuthenticationParameters;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<P2SVpnGatewayInner> p2SVpnGateways() {
        return this.p2SVpnGateways;
    }

    public List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups() {
        return this.configurationPolicyGroups;
    }

    public VpnServerConfigurationProperties withConfigurationPolicyGroups(List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups) {
        this.configurationPolicyGroups = configurationPolicyGroups;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public void validate() {
        if (this.vpnClientRootCertificates() != null) {
            this.vpnClientRootCertificates().forEach(e -> e.validate());
        }
        if (this.vpnClientRevokedCertificates() != null) {
            this.vpnClientRevokedCertificates().forEach(e -> e.validate());
        }
        if (this.radiusServerRootCertificates() != null) {
            this.radiusServerRootCertificates().forEach(e -> e.validate());
        }
        if (this.radiusClientRootCertificates() != null) {
            this.radiusClientRootCertificates().forEach(e -> e.validate());
        }
        if (this.vpnClientIpsecPolicies() != null) {
            this.vpnClientIpsecPolicies().forEach(e -> e.validate());
        }
        if (this.radiusServers() != null) {
            this.radiusServers().forEach(e -> e.validate());
        }
        if (this.aadAuthenticationParameters() != null) {
            this.aadAuthenticationParameters().validate();
        }
        if (this.p2SVpnGateways() != null) {
            this.p2SVpnGateways().forEach(e -> e.validate());
        }
        if (this.configurationPolicyGroups() != null) {
            this.configurationPolicyGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("vpnProtocols", this.vpnProtocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnAuthenticationTypes", this.vpnAuthenticationTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnClientRootCertificates", this.vpnClientRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("vpnClientRevokedCertificates", this.vpnClientRevokedCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("radiusServerRootCertificates", this.radiusServerRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("radiusClientRootCertificates", this.radiusClientRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("vpnClientIpsecPolicies", this.vpnClientIpsecPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        jsonWriter.writeArrayField("radiusServers", this.radiusServers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("aadAuthenticationParameters", (JsonSerializable)this.aadAuthenticationParameters);
        jsonWriter.writeArrayField("configurationPolicyGroups", this.configurationPolicyGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VpnServerConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VpnServerConfigurationProperties)jsonReader.readObject(reader -> {
            VpnServerConfigurationProperties deserializedVpnServerConfigurationProperties = new VpnServerConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.name = reader.getString();
                    continue;
                }
                if ("vpnProtocols".equals(fieldName)) {
                    List vpnProtocols;
                    deserializedVpnServerConfigurationProperties.vpnProtocols = vpnProtocols = reader.readArray(reader1 -> VpnGatewayTunnelingProtocol.fromString(reader1.getString()));
                    continue;
                }
                if ("vpnAuthenticationTypes".equals(fieldName)) {
                    List vpnAuthenticationTypes;
                    deserializedVpnServerConfigurationProperties.vpnAuthenticationTypes = vpnAuthenticationTypes = reader.readArray(reader1 -> VpnAuthenticationType.fromString(reader1.getString()));
                    continue;
                }
                if ("vpnClientRootCertificates".equals(fieldName)) {
                    List vpnClientRootCertificates;
                    deserializedVpnServerConfigurationProperties.vpnClientRootCertificates = vpnClientRootCertificates = reader.readArray(reader1 -> VpnServerConfigVpnClientRootCertificate.fromJson(reader1));
                    continue;
                }
                if ("vpnClientRevokedCertificates".equals(fieldName)) {
                    List vpnClientRevokedCertificates;
                    deserializedVpnServerConfigurationProperties.vpnClientRevokedCertificates = vpnClientRevokedCertificates = reader.readArray(reader1 -> VpnServerConfigVpnClientRevokedCertificate.fromJson(reader1));
                    continue;
                }
                if ("radiusServerRootCertificates".equals(fieldName)) {
                    List radiusServerRootCertificates;
                    deserializedVpnServerConfigurationProperties.radiusServerRootCertificates = radiusServerRootCertificates = reader.readArray(reader1 -> VpnServerConfigRadiusServerRootCertificate.fromJson(reader1));
                    continue;
                }
                if ("radiusClientRootCertificates".equals(fieldName)) {
                    List radiusClientRootCertificates;
                    deserializedVpnServerConfigurationProperties.radiusClientRootCertificates = radiusClientRootCertificates = reader.readArray(reader1 -> VpnServerConfigRadiusClientRootCertificate.fromJson(reader1));
                    continue;
                }
                if ("vpnClientIpsecPolicies".equals(fieldName)) {
                    List vpnClientIpsecPolicies;
                    deserializedVpnServerConfigurationProperties.vpnClientIpsecPolicies = vpnClientIpsecPolicies = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    continue;
                }
                if ("radiusServerAddress".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.radiusServerAddress = reader.getString();
                    continue;
                }
                if ("radiusServerSecret".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.radiusServerSecret = reader.getString();
                    continue;
                }
                if ("radiusServers".equals(fieldName)) {
                    List radiusServers;
                    deserializedVpnServerConfigurationProperties.radiusServers = radiusServers = reader.readArray(reader1 -> RadiusServer.fromJson(reader1));
                    continue;
                }
                if ("aadAuthenticationParameters".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.aadAuthenticationParameters = AadAuthenticationParameters.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("p2SVpnGateways".equals(fieldName)) {
                    List p2SVpnGateways;
                    deserializedVpnServerConfigurationProperties.p2SVpnGateways = p2SVpnGateways = reader.readArray(reader1 -> P2SVpnGatewayInner.fromJson(reader1));
                    continue;
                }
                if ("configurationPolicyGroups".equals(fieldName)) {
                    List configurationPolicyGroups;
                    deserializedVpnServerConfigurationProperties.configurationPolicyGroups = configurationPolicyGroups = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupInner.fromJson(reader1));
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnServerConfigurationProperties;
        });
    }
}

