/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExclusionManagedRule;
import java.io.IOException;
import java.util.List;

public final class ExclusionManagedRuleGroup
implements JsonSerializable<ExclusionManagedRuleGroup> {
    private String ruleGroupName;
    private List<ExclusionManagedRule> rules;
    private static final ClientLogger LOGGER = new ClientLogger(ExclusionManagedRuleGroup.class);

    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    public ExclusionManagedRuleGroup withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    public List<ExclusionManagedRule> rules() {
        return this.rules;
    }

    public ExclusionManagedRuleGroup withRules(List<ExclusionManagedRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.ruleGroupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleGroupName in model ExclusionManagedRuleGroup"));
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExclusionManagedRuleGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ExclusionManagedRuleGroup)jsonReader.readObject(reader -> {
            ExclusionManagedRuleGroup deserializedExclusionManagedRuleGroup = new ExclusionManagedRuleGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleGroupName".equals(fieldName)) {
                    deserializedExclusionManagedRuleGroup.ruleGroupName = reader.getString();
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedExclusionManagedRuleGroup.rules = rules = reader.readArray(reader1 -> ExclusionManagedRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExclusionManagedRuleGroup;
        });
    }
}

