/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import java.io.IOException;

public final class TunnelConnectionHealth
implements JsonSerializable<TunnelConnectionHealth> {
    private String tunnel;
    private VirtualNetworkGatewayConnectionStatus connectionStatus;
    private Long ingressBytesTransferred;
    private Long egressBytesTransferred;
    private String lastConnectionEstablishedUtcTime;

    public String tunnel() {
        return this.tunnel;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public String lastConnectionEstablishedUtcTime() {
        return this.lastConnectionEstablishedUtcTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static TunnelConnectionHealth fromJson(JsonReader jsonReader) throws IOException {
        return (TunnelConnectionHealth)jsonReader.readObject(reader -> {
            TunnelConnectionHealth deserializedTunnelConnectionHealth = new TunnelConnectionHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tunnel".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.tunnel = reader.getString();
                    continue;
                }
                if ("connectionStatus".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.connectionStatus = VirtualNetworkGatewayConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.ingressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.egressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastConnectionEstablishedUtcTime".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.lastConnectionEstablishedUtcTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTunnelConnectionHealth;
        });
    }
}

