// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of an application gateway private link IP configuration.
 */
@Fluent
public final class ApplicationGatewayPrivateLinkIpConfigurationProperties
    implements JsonSerializable<ApplicationGatewayPrivateLinkIpConfigurationProperties> {
    /*
     * The private IP address of the IP configuration.
     */
    private String privateIpAddress;

    /*
     * The private IP address allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Reference to the subnet resource.
     */
    private SubResource subnet;

    /*
     * Whether the ip configuration is primary or not.
     */
    private Boolean primary;

    /*
     * The provisioning state of the application gateway private link IP configuration.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayPrivateLinkIpConfigurationProperties class.
     */
    public ApplicationGatewayPrivateLinkIpConfigurationProperties() {
    }

    /**
     * Get the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: The private IP address of the IP configuration.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the ApplicationGatewayPrivateLinkIpConfigurationProperties object itself.
     */
    public ApplicationGatewayPrivateLinkIpConfigurationProperties withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the ApplicationGatewayPrivateLinkIpConfigurationProperties object itself.
     */
    public ApplicationGatewayPrivateLinkIpConfigurationProperties
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the subnet property: Reference to the subnet resource.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Reference to the subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the ApplicationGatewayPrivateLinkIpConfigurationProperties object itself.
     */
    public ApplicationGatewayPrivateLinkIpConfigurationProperties withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the primary property: Whether the ip configuration is primary or not.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Whether the ip configuration is primary or not.
     * 
     * @param primary the primary value to set.
     * @return the ApplicationGatewayPrivateLinkIpConfigurationProperties object itself.
     */
    public ApplicationGatewayPrivateLinkIpConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the application gateway private link IP
     * configuration.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayPrivateLinkIpConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayPrivateLinkIpConfigurationProperties if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayPrivateLinkIpConfigurationProperties.
     */
    public static ApplicationGatewayPrivateLinkIpConfigurationProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateLinkIpConfigurationProperties deserializedApplicationGatewayPrivateLinkIpConfigurationProperties
                = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.privateIpAddress
                        = reader.getString();
                } else if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.subnet
                        = SubResource.fromJson(reader);
                } else if ("primary".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayPrivateLinkIpConfigurationProperties;
        });
    }
}
