// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of ResourceNavigationLink.
 */
@Fluent
public final class ResourceNavigationLinkFormat implements JsonSerializable<ResourceNavigationLinkFormat> {
    /*
     * Resource type of the linked resource.
     */
    private String linkedResourceType;

    /*
     * Link to the external resource.
     */
    private String link;

    /*
     * The provisioning state of the resource navigation link resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ResourceNavigationLinkFormat class.
     */
    public ResourceNavigationLinkFormat() {
    }

    /**
     * Get the linkedResourceType property: Resource type of the linked resource.
     * 
     * @return the linkedResourceType value.
     */
    public String linkedResourceType() {
        return this.linkedResourceType;
    }

    /**
     * Set the linkedResourceType property: Resource type of the linked resource.
     * 
     * @param linkedResourceType the linkedResourceType value to set.
     * @return the ResourceNavigationLinkFormat object itself.
     */
    public ResourceNavigationLinkFormat withLinkedResourceType(String linkedResourceType) {
        this.linkedResourceType = linkedResourceType;
        return this;
    }

    /**
     * Get the link property: Link to the external resource.
     * 
     * @return the link value.
     */
    public String link() {
        return this.link;
    }

    /**
     * Set the link property: Link to the external resource.
     * 
     * @param link the link value to set.
     * @return the ResourceNavigationLinkFormat object itself.
     */
    public ResourceNavigationLinkFormat withLink(String link) {
        this.link = link;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource navigation link resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedResourceType", this.linkedResourceType);
        jsonWriter.writeStringField("link", this.link);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNavigationLinkFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNavigationLinkFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceNavigationLinkFormat.
     */
    public static ResourceNavigationLinkFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNavigationLinkFormat deserializedResourceNavigationLinkFormat = new ResourceNavigationLinkFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linkedResourceType".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.linkedResourceType = reader.getString();
                } else if ("link".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.link = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceNavigationLinkFormat;
        });
    }
}
