// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains bgp community information offered in Service Community resources.
 */
@Fluent
public final class BgpCommunity implements JsonSerializable<BgpCommunity> {
    /*
     * The region which the service support. e.g. For O365, region is Global.
     */
    private String serviceSupportedRegion;

    /*
     * The name of the bgp community. e.g. Skype.
     */
    private String communityName;

    /*
     * The value of the bgp community. For more information:
     * https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
     */
    private String communityValue;

    /*
     * The prefixes that the bgp community contains.
     */
    private List<String> communityPrefixes;

    /*
     * Customer is authorized to use bgp community or not.
     */
    private Boolean isAuthorizedToUse;

    /*
     * The service group of the bgp community contains.
     */
    private String serviceGroup;

    /**
     * Creates an instance of BgpCommunity class.
     */
    public BgpCommunity() {
    }

    /**
     * Get the serviceSupportedRegion property: The region which the service support. e.g. For O365, region is Global.
     * 
     * @return the serviceSupportedRegion value.
     */
    public String serviceSupportedRegion() {
        return this.serviceSupportedRegion;
    }

    /**
     * Set the serviceSupportedRegion property: The region which the service support. e.g. For O365, region is Global.
     * 
     * @param serviceSupportedRegion the serviceSupportedRegion value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withServiceSupportedRegion(String serviceSupportedRegion) {
        this.serviceSupportedRegion = serviceSupportedRegion;
        return this;
    }

    /**
     * Get the communityName property: The name of the bgp community. e.g. Skype.
     * 
     * @return the communityName value.
     */
    public String communityName() {
        return this.communityName;
    }

    /**
     * Set the communityName property: The name of the bgp community. e.g. Skype.
     * 
     * @param communityName the communityName value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withCommunityName(String communityName) {
        this.communityName = communityName;
        return this;
    }

    /**
     * Get the communityValue property: The value of the bgp community. For more information:
     * https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
     * 
     * @return the communityValue value.
     */
    public String communityValue() {
        return this.communityValue;
    }

    /**
     * Set the communityValue property: The value of the bgp community. For more information:
     * https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
     * 
     * @param communityValue the communityValue value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withCommunityValue(String communityValue) {
        this.communityValue = communityValue;
        return this;
    }

    /**
     * Get the communityPrefixes property: The prefixes that the bgp community contains.
     * 
     * @return the communityPrefixes value.
     */
    public List<String> communityPrefixes() {
        return this.communityPrefixes;
    }

    /**
     * Set the communityPrefixes property: The prefixes that the bgp community contains.
     * 
     * @param communityPrefixes the communityPrefixes value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withCommunityPrefixes(List<String> communityPrefixes) {
        this.communityPrefixes = communityPrefixes;
        return this;
    }

    /**
     * Get the isAuthorizedToUse property: Customer is authorized to use bgp community or not.
     * 
     * @return the isAuthorizedToUse value.
     */
    public Boolean isAuthorizedToUse() {
        return this.isAuthorizedToUse;
    }

    /**
     * Set the isAuthorizedToUse property: Customer is authorized to use bgp community or not.
     * 
     * @param isAuthorizedToUse the isAuthorizedToUse value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withIsAuthorizedToUse(Boolean isAuthorizedToUse) {
        this.isAuthorizedToUse = isAuthorizedToUse;
        return this;
    }

    /**
     * Get the serviceGroup property: The service group of the bgp community contains.
     * 
     * @return the serviceGroup value.
     */
    public String serviceGroup() {
        return this.serviceGroup;
    }

    /**
     * Set the serviceGroup property: The service group of the bgp community contains.
     * 
     * @param serviceGroup the serviceGroup value to set.
     * @return the BgpCommunity object itself.
     */
    public BgpCommunity withServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceSupportedRegion", this.serviceSupportedRegion);
        jsonWriter.writeStringField("communityName", this.communityName);
        jsonWriter.writeStringField("communityValue", this.communityValue);
        jsonWriter.writeArrayField("communityPrefixes", this.communityPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isAuthorizedToUse", this.isAuthorizedToUse);
        jsonWriter.writeStringField("serviceGroup", this.serviceGroup);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpCommunity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpCommunity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BgpCommunity.
     */
    public static BgpCommunity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpCommunity deserializedBgpCommunity = new BgpCommunity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceSupportedRegion".equals(fieldName)) {
                    deserializedBgpCommunity.serviceSupportedRegion = reader.getString();
                } else if ("communityName".equals(fieldName)) {
                    deserializedBgpCommunity.communityName = reader.getString();
                } else if ("communityValue".equals(fieldName)) {
                    deserializedBgpCommunity.communityValue = reader.getString();
                } else if ("communityPrefixes".equals(fieldName)) {
                    List<String> communityPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBgpCommunity.communityPrefixes = communityPrefixes;
                } else if ("isAuthorizedToUse".equals(fieldName)) {
                    deserializedBgpCommunity.isAuthorizedToUse = reader.getNullable(JsonReader::getBoolean);
                } else if ("serviceGroup".equals(fieldName)) {
                    deserializedBgpCommunity.serviceGroup = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpCommunity;
        });
    }
}
