// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network base admin rule.
 */
@Fluent
public class EffectiveBaseSecurityAdminRule implements JsonSerializable<EffectiveBaseSecurityAdminRule> {
    /*
     * Whether the rule is custom or default.
     */
    private EffectiveAdminRuleKind kind = EffectiveAdminRuleKind.fromString("EffectiveBaseSecurityAdminRule");

    /*
     * Resource ID.
     */
    private String id;

    /*
     * A description of the security admin configuration.
     */
    private String configurationDescription;

    /*
     * A description of the rule collection.
     */
    private String ruleCollectionDescription;

    /*
     * Groups for rule collection
     */
    private List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups;

    /*
     * Effective configuration groups.
     */
    private List<ConfigurationGroup> ruleGroups;

    /**
     * Creates an instance of EffectiveBaseSecurityAdminRule class.
     */
    public EffectiveBaseSecurityAdminRule() {
    }

    /**
     * Get the kind property: Whether the rule is custom or default.
     * 
     * @return the kind value.
     */
    public EffectiveAdminRuleKind kind() {
        return this.kind;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the EffectiveBaseSecurityAdminRule object itself.
     */
    public EffectiveBaseSecurityAdminRule withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the configurationDescription property: A description of the security admin configuration.
     * 
     * @return the configurationDescription value.
     */
    public String configurationDescription() {
        return this.configurationDescription;
    }

    /**
     * Set the configurationDescription property: A description of the security admin configuration.
     * 
     * @param configurationDescription the configurationDescription value to set.
     * @return the EffectiveBaseSecurityAdminRule object itself.
     */
    public EffectiveBaseSecurityAdminRule withConfigurationDescription(String configurationDescription) {
        this.configurationDescription = configurationDescription;
        return this;
    }

    /**
     * Get the ruleCollectionDescription property: A description of the rule collection.
     * 
     * @return the ruleCollectionDescription value.
     */
    public String ruleCollectionDescription() {
        return this.ruleCollectionDescription;
    }

    /**
     * Set the ruleCollectionDescription property: A description of the rule collection.
     * 
     * @param ruleCollectionDescription the ruleCollectionDescription value to set.
     * @return the EffectiveBaseSecurityAdminRule object itself.
     */
    public EffectiveBaseSecurityAdminRule withRuleCollectionDescription(String ruleCollectionDescription) {
        this.ruleCollectionDescription = ruleCollectionDescription;
        return this;
    }

    /**
     * Get the ruleCollectionAppliesToGroups property: Groups for rule collection.
     * 
     * @return the ruleCollectionAppliesToGroups value.
     */
    public List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups() {
        return this.ruleCollectionAppliesToGroups;
    }

    /**
     * Set the ruleCollectionAppliesToGroups property: Groups for rule collection.
     * 
     * @param ruleCollectionAppliesToGroups the ruleCollectionAppliesToGroups value to set.
     * @return the EffectiveBaseSecurityAdminRule object itself.
     */
    public EffectiveBaseSecurityAdminRule
        withRuleCollectionAppliesToGroups(List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups) {
        this.ruleCollectionAppliesToGroups = ruleCollectionAppliesToGroups;
        return this;
    }

    /**
     * Get the ruleGroups property: Effective configuration groups.
     * 
     * @return the ruleGroups value.
     */
    public List<ConfigurationGroup> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Set the ruleGroups property: Effective configuration groups.
     * 
     * @param ruleGroups the ruleGroups value to set.
     * @return the EffectiveBaseSecurityAdminRule object itself.
     */
    public EffectiveBaseSecurityAdminRule withRuleGroups(List<ConfigurationGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleCollectionAppliesToGroups() != null) {
            ruleCollectionAppliesToGroups().forEach(e -> e.validate());
        }
        if (ruleGroups() != null) {
            ruleGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("configurationDescription", this.configurationDescription);
        jsonWriter.writeStringField("ruleCollectionDescription", this.ruleCollectionDescription);
        jsonWriter.writeArrayField("ruleCollectionAppliesToGroups", this.ruleCollectionAppliesToGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveBaseSecurityAdminRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveBaseSecurityAdminRule if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveBaseSecurityAdminRule.
     */
    public static EffectiveBaseSecurityAdminRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("Custom".equals(discriminatorValue)) {
                    return EffectiveSecurityAdminRule.fromJson(readerToUse.reset());
                } else if ("Default".equals(discriminatorValue)) {
                    return EffectiveDefaultSecurityAdminRule.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static EffectiveBaseSecurityAdminRule fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveBaseSecurityAdminRule deserializedEffectiveBaseSecurityAdminRule
                = new EffectiveBaseSecurityAdminRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedEffectiveBaseSecurityAdminRule.kind
                        = EffectiveAdminRuleKind.fromString(reader.getString());
                } else if ("id".equals(fieldName)) {
                    deserializedEffectiveBaseSecurityAdminRule.id = reader.getString();
                } else if ("configurationDescription".equals(fieldName)) {
                    deserializedEffectiveBaseSecurityAdminRule.configurationDescription = reader.getString();
                } else if ("ruleCollectionDescription".equals(fieldName)) {
                    deserializedEffectiveBaseSecurityAdminRule.ruleCollectionDescription = reader.getString();
                } else if ("ruleCollectionAppliesToGroups".equals(fieldName)) {
                    List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups
                        = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    deserializedEffectiveBaseSecurityAdminRule.ruleCollectionAppliesToGroups
                        = ruleCollectionAppliesToGroups;
                } else if ("ruleGroups".equals(fieldName)) {
                    List<ConfigurationGroup> ruleGroups
                        = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedEffectiveBaseSecurityAdminRule.ruleGroups = ruleGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveBaseSecurityAdminRule;
        });
    }
}
