// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerVipSwapRequestFrontendIpConfigurationProperties;
import java.io.IOException;

/**
 * VIP swap request's frontend IP configuration object.
 */
@Fluent
public final class LoadBalancerVipSwapRequestFrontendIpConfiguration
    implements JsonSerializable<LoadBalancerVipSwapRequestFrontendIpConfiguration> {
    /*
     * The ID of frontend IP configuration resource.
     */
    private String id;

    /*
     * The properties of VIP swap request's frontend IP configuration object.
     */
    private LoadBalancerVipSwapRequestFrontendIpConfigurationProperties innerProperties;

    /**
     * Creates an instance of LoadBalancerVipSwapRequestFrontendIpConfiguration class.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration() {
    }

    /**
     * Get the id property: The ID of frontend IP configuration resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of frontend IP configuration resource.
     * 
     * @param id the id value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of VIP swap request's frontend IP configuration object.
     * 
     * @return the innerProperties value.
     */
    private LoadBalancerVipSwapRequestFrontendIpConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the publicIpAddress property: A reference to public IP address resource.
     * 
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddress();
    }

    /**
     * Set the publicIpAddress property: A reference to public IP address resource.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withPublicIpAddress(SubResource publicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerVipSwapRequestFrontendIpConfigurationProperties();
        }
        this.innerProperties().withPublicIpAddress(publicIpAddress);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerVipSwapRequestFrontendIpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerVipSwapRequestFrontendIpConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerVipSwapRequestFrontendIpConfiguration.
     */
    public static LoadBalancerVipSwapRequestFrontendIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerVipSwapRequestFrontendIpConfiguration deserializedLoadBalancerVipSwapRequestFrontendIpConfiguration
                = new LoadBalancerVipSwapRequestFrontendIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLoadBalancerVipSwapRequestFrontendIpConfiguration.id = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLoadBalancerVipSwapRequestFrontendIpConfiguration.innerProperties
                        = LoadBalancerVipSwapRequestFrontendIpConfigurationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerVipSwapRequestFrontendIpConfiguration;
        });
    }
}
