// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Will contain the properties of the resource (the actual signature overrides).
 */
@Fluent
public final class SignaturesOverridesProperties implements JsonSerializable<SignaturesOverridesProperties> {
    /*
     * Dictionary of <string>
     */
    private Map<String, String> signatures;

    /**
     * Creates an instance of SignaturesOverridesProperties class.
     */
    public SignaturesOverridesProperties() {
    }

    /**
     * Get the signatures property: Dictionary of &lt;string&gt;.
     * 
     * @return the signatures value.
     */
    public Map<String, String> signatures() {
        return this.signatures;
    }

    /**
     * Set the signatures property: Dictionary of &lt;string&gt;.
     * 
     * @param signatures the signatures value to set.
     * @return the SignaturesOverridesProperties object itself.
     */
    public SignaturesOverridesProperties withSignatures(Map<String, String> signatures) {
        this.signatures = signatures;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("signatures", this.signatures, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SignaturesOverridesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SignaturesOverridesProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SignaturesOverridesProperties.
     */
    public static SignaturesOverridesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignaturesOverridesProperties deserializedSignaturesOverridesProperties
                = new SignaturesOverridesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("signatures".equals(fieldName)) {
                    Map<String, String> signatures = reader.readMap(reader1 -> reader1.getString());
                    deserializedSignaturesOverridesProperties.signatures = signatures;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSignaturesOverridesProperties;
        });
    }
}
