// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * VirtualNetworkGatewayConnection properties.
 */
@Immutable
public final class TunnelConnectionHealth implements JsonSerializable<TunnelConnectionHealth> {
    /*
     * Tunnel name.
     */
    private String tunnel;

    /*
     * Virtual Network Gateway connection status.
     */
    private VirtualNetworkGatewayConnectionStatus connectionStatus;

    /*
     * The Ingress Bytes Transferred in this connection.
     */
    private Long ingressBytesTransferred;

    /*
     * The Egress Bytes Transferred in this connection.
     */
    private Long egressBytesTransferred;

    /*
     * The time at which connection was established in Utc format.
     */
    private String lastConnectionEstablishedUtcTime;

    /**
     * Creates an instance of TunnelConnectionHealth class.
     */
    public TunnelConnectionHealth() {
    }

    /**
     * Get the tunnel property: Tunnel name.
     * 
     * @return the tunnel value.
     */
    public String tunnel() {
        return this.tunnel;
    }

    /**
     * Get the connectionStatus property: Virtual Network Gateway connection status.
     * 
     * @return the connectionStatus value.
     */
    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    /**
     * Get the ingressBytesTransferred property: The Ingress Bytes Transferred in this connection.
     * 
     * @return the ingressBytesTransferred value.
     */
    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    /**
     * Get the egressBytesTransferred property: The Egress Bytes Transferred in this connection.
     * 
     * @return the egressBytesTransferred value.
     */
    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    /**
     * Get the lastConnectionEstablishedUtcTime property: The time at which connection was established in Utc format.
     * 
     * @return the lastConnectionEstablishedUtcTime value.
     */
    public String lastConnectionEstablishedUtcTime() {
        return this.lastConnectionEstablishedUtcTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TunnelConnectionHealth from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TunnelConnectionHealth if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TunnelConnectionHealth.
     */
    public static TunnelConnectionHealth fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TunnelConnectionHealth deserializedTunnelConnectionHealth = new TunnelConnectionHealth();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tunnel".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.tunnel = reader.getString();
                } else if ("connectionStatus".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.connectionStatus
                        = VirtualNetworkGatewayConnectionStatus.fromString(reader.getString());
                } else if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.ingressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.egressBytesTransferred = reader.getNullable(JsonReader::getLong);
                } else if ("lastConnectionEstablishedUtcTime".equals(fieldName)) {
                    deserializedTunnelConnectionHealth.lastConnectionEstablishedUtcTime = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTunnelConnectionHealth;
        });
    }
}
