// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Virtual Appliance Additional Nic Properties
 * 
 * Network Virtual Appliance Additional NIC properties.
 */
@Fluent
public final class VirtualApplianceAdditionalNicProperties
    implements JsonSerializable<VirtualApplianceAdditionalNicProperties> {
    /*
     * Name of additional nic
     */
    private String name;

    /*
     * Flag (true or false) for Intent for Public Ip on additional nic
     */
    private Boolean hasPublicIp;

    /**
     * Creates an instance of VirtualApplianceAdditionalNicProperties class.
     */
    public VirtualApplianceAdditionalNicProperties() {
    }

    /**
     * Get the name property: Name of additional nic.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of additional nic.
     * 
     * @param name the name value to set.
     * @return the VirtualApplianceAdditionalNicProperties object itself.
     */
    public VirtualApplianceAdditionalNicProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the hasPublicIp property: Flag (true or false) for Intent for Public Ip on additional nic.
     * 
     * @return the hasPublicIp value.
     */
    public Boolean hasPublicIp() {
        return this.hasPublicIp;
    }

    /**
     * Set the hasPublicIp property: Flag (true or false) for Intent for Public Ip on additional nic.
     * 
     * @param hasPublicIp the hasPublicIp value to set.
     * @return the VirtualApplianceAdditionalNicProperties object itself.
     */
    public VirtualApplianceAdditionalNicProperties withHasPublicIp(Boolean hasPublicIp) {
        this.hasPublicIp = hasPublicIp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("hasPublicIp", this.hasPublicIp);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceAdditionalNicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceAdditionalNicProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceAdditionalNicProperties.
     */
    public static VirtualApplianceAdditionalNicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceAdditionalNicProperties deserializedVirtualApplianceAdditionalNicProperties
                = new VirtualApplianceAdditionalNicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualApplianceAdditionalNicProperties.name = reader.getString();
                } else if ("hasPublicIp".equals(fieldName)) {
                    deserializedVirtualApplianceAdditionalNicProperties.hasPublicIp
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceAdditionalNicProperties;
        });
    }
}
