// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * VirtualNetworkGatewaySku details.
 */
@Fluent
public final class VirtualNetworkGatewaySku implements JsonSerializable<VirtualNetworkGatewaySku> {
    /*
     * Gateway SKU name.
     */
    private VirtualNetworkGatewaySkuName name;

    /*
     * Gateway SKU tier.
     */
    private VirtualNetworkGatewaySkuTier tier;

    /*
     * The capacity.
     */
    private Integer capacity;

    /**
     * Creates an instance of VirtualNetworkGatewaySku class.
     */
    public VirtualNetworkGatewaySku() {
    }

    /**
     * Get the name property: Gateway SKU name.
     * 
     * @return the name value.
     */
    public VirtualNetworkGatewaySkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Gateway SKU name.
     * 
     * @param name the name value to set.
     * @return the VirtualNetworkGatewaySku object itself.
     */
    public VirtualNetworkGatewaySku withName(VirtualNetworkGatewaySkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: Gateway SKU tier.
     * 
     * @return the tier value.
     */
    public VirtualNetworkGatewaySkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Gateway SKU tier.
     * 
     * @param tier the tier value to set.
     * @return the VirtualNetworkGatewaySku object itself.
     */
    public VirtualNetworkGatewaySku withTier(VirtualNetworkGatewaySkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the capacity property: The capacity.
     * 
     * @return the capacity value.
     */
    public Integer capacity() {
        return this.capacity;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewaySku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewaySku if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewaySku.
     */
    public static VirtualNetworkGatewaySku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewaySku deserializedVirtualNetworkGatewaySku = new VirtualNetworkGatewaySku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkGatewaySku.name
                        = VirtualNetworkGatewaySkuName.fromString(reader.getString());
                } else if ("tier".equals(fieldName)) {
                    deserializedVirtualNetworkGatewaySku.tier
                        = VirtualNetworkGatewaySkuTier.fromString(reader.getString());
                } else if ("capacity".equals(fieldName)) {
                    deserializedVirtualNetworkGatewaySku.capacity = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewaySku;
        });
    }
}
