/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NatGatewayInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.models.DdosSettings;
import com.azure.resourcemanager.network.models.DeleteOptions;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddressMigrationPhase;
import java.io.IOException;
import java.util.List;

public final class PublicIpAddressPropertiesFormatInner
implements JsonSerializable<PublicIpAddressPropertiesFormatInner> {
    private IpAllocationMethod publicIpAllocationMethod;
    private IpVersion publicIpAddressVersion;
    private IpConfigurationInner ipConfiguration;
    private PublicIpAddressDnsSettings dnsSettings;
    private DdosSettings ddosSettings;
    private List<IpTag> ipTags;
    private String ipAddress;
    private SubResource publicIpPrefix;
    private Integer idleTimeoutInMinutes;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private PublicIpAddressInner servicePublicIpAddress;
    private NatGatewayInner natGateway;
    private PublicIpAddressMigrationPhase migrationPhase;
    private PublicIpAddressInner linkedPublicIpAddress;
    private DeleteOptions deleteOption;

    public IpAllocationMethod publicIpAllocationMethod() {
        return this.publicIpAllocationMethod;
    }

    public PublicIpAddressPropertiesFormatInner withPublicIpAllocationMethod(IpAllocationMethod publicIpAllocationMethod) {
        this.publicIpAllocationMethod = publicIpAllocationMethod;
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public PublicIpAddressPropertiesFormatInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public IpConfigurationInner ipConfiguration() {
        return this.ipConfiguration;
    }

    public PublicIpAddressDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public PublicIpAddressPropertiesFormatInner withDnsSettings(PublicIpAddressDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public DdosSettings ddosSettings() {
        return this.ddosSettings;
    }

    public PublicIpAddressPropertiesFormatInner withDdosSettings(DdosSettings ddosSettings) {
        this.ddosSettings = ddosSettings;
        return this;
    }

    public List<IpTag> ipTags() {
        return this.ipTags;
    }

    public PublicIpAddressPropertiesFormatInner withIpTags(List<IpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public PublicIpAddressPropertiesFormatInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public PublicIpAddressPropertiesFormatInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public PublicIpAddressPropertiesFormatInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PublicIpAddressInner servicePublicIpAddress() {
        return this.servicePublicIpAddress;
    }

    public PublicIpAddressPropertiesFormatInner withServicePublicIpAddress(PublicIpAddressInner servicePublicIpAddress) {
        this.servicePublicIpAddress = servicePublicIpAddress;
        return this;
    }

    public NatGatewayInner natGateway() {
        return this.natGateway;
    }

    public PublicIpAddressPropertiesFormatInner withNatGateway(NatGatewayInner natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    public PublicIpAddressMigrationPhase migrationPhase() {
        return this.migrationPhase;
    }

    public PublicIpAddressPropertiesFormatInner withMigrationPhase(PublicIpAddressMigrationPhase migrationPhase) {
        this.migrationPhase = migrationPhase;
        return this;
    }

    public PublicIpAddressInner linkedPublicIpAddress() {
        return this.linkedPublicIpAddress;
    }

    public PublicIpAddressPropertiesFormatInner withLinkedPublicIpAddress(PublicIpAddressInner linkedPublicIpAddress) {
        this.linkedPublicIpAddress = linkedPublicIpAddress;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public PublicIpAddressPropertiesFormatInner withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.ipConfiguration() != null) {
            this.ipConfiguration().validate();
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ddosSettings() != null) {
            this.ddosSettings().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
        if (this.servicePublicIpAddress() != null) {
            this.servicePublicIpAddress().validate();
        }
        if (this.natGateway() != null) {
            this.natGateway().validate();
        }
        if (this.linkedPublicIpAddress() != null) {
            this.linkedPublicIpAddress().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicIPAllocationMethod", this.publicIpAllocationMethod == null ? null : this.publicIpAllocationMethod.toString());
        jsonWriter.writeStringField("publicIPAddressVersion", this.publicIpAddressVersion == null ? null : this.publicIpAddressVersion.toString());
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeJsonField("ddosSettings", (JsonSerializable)this.ddosSettings);
        jsonWriter.writeArrayField("ipTags", this.ipTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeJsonField("publicIPPrefix", (JsonSerializable)this.publicIpPrefix);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeJsonField("servicePublicIPAddress", (JsonSerializable)this.servicePublicIpAddress);
        jsonWriter.writeJsonField("natGateway", (JsonSerializable)this.natGateway);
        jsonWriter.writeStringField("migrationPhase", this.migrationPhase == null ? null : this.migrationPhase.toString());
        jsonWriter.writeJsonField("linkedPublicIPAddress", (JsonSerializable)this.linkedPublicIpAddress);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static PublicIpAddressPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (PublicIpAddressPropertiesFormatInner)jsonReader.readObject(reader -> {
            PublicIpAddressPropertiesFormatInner deserializedPublicIpAddressPropertiesFormatInner = new PublicIpAddressPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicIPAllocationMethod".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.publicIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("publicIPAddressVersion".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.publicIpAddressVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                if ("ipConfiguration".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.ipConfiguration = IpConfigurationInner.fromJson(reader);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.dnsSettings = PublicIpAddressDnsSettings.fromJson(reader);
                    continue;
                }
                if ("ddosSettings".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.ddosSettings = DdosSettings.fromJson(reader);
                    continue;
                }
                if ("ipTags".equals(fieldName)) {
                    List ipTags;
                    deserializedPublicIpAddressPropertiesFormatInner.ipTags = ipTags = reader.readArray(reader1 -> IpTag.fromJson(reader1));
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.ipAddress = reader.getString();
                    continue;
                }
                if ("publicIPPrefix".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.publicIpPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("servicePublicIPAddress".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.servicePublicIpAddress = PublicIpAddressInner.fromJson(reader);
                    continue;
                }
                if ("natGateway".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.natGateway = NatGatewayInner.fromJson(reader);
                    continue;
                }
                if ("migrationPhase".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.migrationPhase = PublicIpAddressMigrationPhase.fromString(reader.getString());
                    continue;
                }
                if ("linkedPublicIPAddress".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.linkedPublicIpAddress = PublicIpAddressInner.fromJson(reader);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedPublicIpAddressPropertiesFormatInner.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicIpAddressPropertiesFormatInner;
        });
    }
}

