/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyInner;
import com.azure.resourcemanager.network.models.Delegation;
import com.azure.resourcemanager.network.models.IpamPoolPrefixAllocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ResourceNavigationLink;
import com.azure.resourcemanager.network.models.ServiceAssociationLink;
import com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.azure.resourcemanager.network.models.SharingScope;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateEndpointNetworkPolicies;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies;
import java.io.IOException;
import java.util.List;

public final class SubnetPropertiesFormatInner
implements JsonSerializable<SubnetPropertiesFormatInner> {
    private String addressPrefix;
    private List<String> addressPrefixes;
    private NetworkSecurityGroupInner networkSecurityGroup;
    private RouteTableInner routeTable;
    private SubResource natGateway;
    private List<ServiceEndpointPropertiesFormat> serviceEndpoints;
    private List<ServiceEndpointPolicyInner> serviceEndpointPolicies;
    private List<PrivateEndpointInner> privateEndpoints;
    private List<IpConfigurationInner> ipConfigurations;
    private List<IpConfigurationProfileInner> ipConfigurationProfiles;
    private List<SubResource> ipAllocations;
    private List<ResourceNavigationLink> resourceNavigationLinks;
    private List<ServiceAssociationLink> serviceAssociationLinks;
    private List<Delegation> delegations;
    private String purpose;
    private ProvisioningState provisioningState;
    private VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies;
    private VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies;
    private List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations;
    private SharingScope sharingScope;
    private Boolean defaultOutboundAccess;
    private List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations;

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public SubnetPropertiesFormatInner withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public SubnetPropertiesFormatInner withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public SubnetPropertiesFormatInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public RouteTableInner routeTable() {
        return this.routeTable;
    }

    public SubnetPropertiesFormatInner withRouteTable(RouteTableInner routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    public SubResource natGateway() {
        return this.natGateway;
    }

    public SubnetPropertiesFormatInner withNatGateway(SubResource natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    public List<ServiceEndpointPropertiesFormat> serviceEndpoints() {
        return this.serviceEndpoints;
    }

    public SubnetPropertiesFormatInner withServiceEndpoints(List<ServiceEndpointPropertiesFormat> serviceEndpoints) {
        this.serviceEndpoints = serviceEndpoints;
        return this;
    }

    public List<ServiceEndpointPolicyInner> serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    public SubnetPropertiesFormatInner withServiceEndpointPolicies(List<ServiceEndpointPolicyInner> serviceEndpointPolicies) {
        this.serviceEndpointPolicies = serviceEndpointPolicies;
        return this;
    }

    public List<PrivateEndpointInner> privateEndpoints() {
        return this.privateEndpoints;
    }

    public List<IpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public List<IpConfigurationProfileInner> ipConfigurationProfiles() {
        return this.ipConfigurationProfiles;
    }

    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    public SubnetPropertiesFormatInner withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    public List<ResourceNavigationLink> resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    public List<ServiceAssociationLink> serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    public List<Delegation> delegations() {
        return this.delegations;
    }

    public SubnetPropertiesFormatInner withDelegations(List<Delegation> delegations) {
        this.delegations = delegations;
        return this;
    }

    public String purpose() {
        return this.purpose;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies() {
        return this.privateEndpointNetworkPolicies;
    }

    public SubnetPropertiesFormatInner withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies) {
        this.privateEndpointNetworkPolicies = privateEndpointNetworkPolicies;
        return this;
    }

    public VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies() {
        return this.privateLinkServiceNetworkPolicies;
    }

    public SubnetPropertiesFormatInner withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies) {
        this.privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies;
        return this;
    }

    public List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations() {
        return this.applicationGatewayIpConfigurations;
    }

    public SubnetPropertiesFormatInner withApplicationGatewayIpConfigurations(List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations) {
        this.applicationGatewayIpConfigurations = applicationGatewayIpConfigurations;
        return this;
    }

    public SharingScope sharingScope() {
        return this.sharingScope;
    }

    public SubnetPropertiesFormatInner withSharingScope(SharingScope sharingScope) {
        this.sharingScope = sharingScope;
        return this;
    }

    public Boolean defaultOutboundAccess() {
        return this.defaultOutboundAccess;
    }

    public SubnetPropertiesFormatInner withDefaultOutboundAccess(Boolean defaultOutboundAccess) {
        this.defaultOutboundAccess = defaultOutboundAccess;
        return this;
    }

    public List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations() {
        return this.ipamPoolPrefixAllocations;
    }

    public SubnetPropertiesFormatInner withIpamPoolPrefixAllocations(List<IpamPoolPrefixAllocation> ipamPoolPrefixAllocations) {
        this.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations;
        return this;
    }

    public void validate() {
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.routeTable() != null) {
            this.routeTable().validate();
        }
        if (this.serviceEndpoints() != null) {
            this.serviceEndpoints().forEach(e -> e.validate());
        }
        if (this.serviceEndpointPolicies() != null) {
            this.serviceEndpointPolicies().forEach(e -> e.validate());
        }
        if (this.privateEndpoints() != null) {
            this.privateEndpoints().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.ipConfigurationProfiles() != null) {
            this.ipConfigurationProfiles().forEach(e -> e.validate());
        }
        if (this.resourceNavigationLinks() != null) {
            this.resourceNavigationLinks().forEach(e -> e.validate());
        }
        if (this.serviceAssociationLinks() != null) {
            this.serviceAssociationLinks().forEach(e -> e.validate());
        }
        if (this.delegations() != null) {
            this.delegations().forEach(e -> e.validate());
        }
        if (this.applicationGatewayIpConfigurations() != null) {
            this.applicationGatewayIpConfigurations().forEach(e -> e.validate());
        }
        if (this.ipamPoolPrefixAllocations() != null) {
            this.ipamPoolPrefixAllocations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeJsonField("routeTable", (JsonSerializable)this.routeTable);
        jsonWriter.writeJsonField("natGateway", (JsonSerializable)this.natGateway);
        jsonWriter.writeArrayField("serviceEndpoints", this.serviceEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("serviceEndpointPolicies", this.serviceEndpointPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipAllocations", this.ipAllocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("delegations", this.delegations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("privateEndpointNetworkPolicies", this.privateEndpointNetworkPolicies == null ? null : this.privateEndpointNetworkPolicies.toString());
        jsonWriter.writeStringField("privateLinkServiceNetworkPolicies", this.privateLinkServiceNetworkPolicies == null ? null : this.privateLinkServiceNetworkPolicies.toString());
        jsonWriter.writeArrayField("applicationGatewayIPConfigurations", this.applicationGatewayIpConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("sharingScope", this.sharingScope == null ? null : this.sharingScope.toString());
        jsonWriter.writeBooleanField("defaultOutboundAccess", this.defaultOutboundAccess);
        jsonWriter.writeArrayField("ipamPoolPrefixAllocations", this.ipamPoolPrefixAllocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SubnetPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return (SubnetPropertiesFormatInner)jsonReader.readObject(reader -> {
            SubnetPropertiesFormatInner deserializedSubnetPropertiesFormatInner = new SubnetPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addressPrefix".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.addressPrefix = reader.getString();
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedSubnetPropertiesFormatInner.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.networkSecurityGroup = NetworkSecurityGroupInner.fromJson(reader);
                    continue;
                }
                if ("routeTable".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.routeTable = RouteTableInner.fromJson(reader);
                    continue;
                }
                if ("natGateway".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.natGateway = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("serviceEndpoints".equals(fieldName)) {
                    List serviceEndpoints;
                    deserializedSubnetPropertiesFormatInner.serviceEndpoints = serviceEndpoints = reader.readArray(reader1 -> ServiceEndpointPropertiesFormat.fromJson(reader1));
                    continue;
                }
                if ("serviceEndpointPolicies".equals(fieldName)) {
                    List serviceEndpointPolicies;
                    deserializedSubnetPropertiesFormatInner.serviceEndpointPolicies = serviceEndpointPolicies = reader.readArray(reader1 -> ServiceEndpointPolicyInner.fromJson(reader1));
                    continue;
                }
                if ("privateEndpoints".equals(fieldName)) {
                    List privateEndpoints;
                    deserializedSubnetPropertiesFormatInner.privateEndpoints = privateEndpoints = reader.readArray(reader1 -> PrivateEndpointInner.fromJson(reader1));
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedSubnetPropertiesFormatInner.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> IpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("ipConfigurationProfiles".equals(fieldName)) {
                    List ipConfigurationProfiles;
                    deserializedSubnetPropertiesFormatInner.ipConfigurationProfiles = ipConfigurationProfiles = reader.readArray(reader1 -> IpConfigurationProfileInner.fromJson(reader1));
                    continue;
                }
                if ("ipAllocations".equals(fieldName)) {
                    List ipAllocations;
                    deserializedSubnetPropertiesFormatInner.ipAllocations = ipAllocations = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("resourceNavigationLinks".equals(fieldName)) {
                    List resourceNavigationLinks;
                    deserializedSubnetPropertiesFormatInner.resourceNavigationLinks = resourceNavigationLinks = reader.readArray(reader1 -> ResourceNavigationLink.fromJson(reader1));
                    continue;
                }
                if ("serviceAssociationLinks".equals(fieldName)) {
                    List serviceAssociationLinks;
                    deserializedSubnetPropertiesFormatInner.serviceAssociationLinks = serviceAssociationLinks = reader.readArray(reader1 -> ServiceAssociationLink.fromJson(reader1));
                    continue;
                }
                if ("delegations".equals(fieldName)) {
                    List delegations;
                    deserializedSubnetPropertiesFormatInner.delegations = delegations = reader.readArray(reader1 -> Delegation.fromJson(reader1));
                    continue;
                }
                if ("purpose".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.purpose = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointNetworkPolicies".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.privateEndpointNetworkPolicies = VirtualNetworkPrivateEndpointNetworkPolicies.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkServiceNetworkPolicies".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.privateLinkServiceNetworkPolicies = VirtualNetworkPrivateLinkServiceNetworkPolicies.fromString(reader.getString());
                    continue;
                }
                if ("applicationGatewayIPConfigurations".equals(fieldName)) {
                    List applicationGatewayIpConfigurations;
                    deserializedSubnetPropertiesFormatInner.applicationGatewayIpConfigurations = applicationGatewayIpConfigurations = reader.readArray(reader1 -> ApplicationGatewayIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("sharingScope".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.sharingScope = SharingScope.fromString(reader.getString());
                    continue;
                }
                if ("defaultOutboundAccess".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.defaultOutboundAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ipamPoolPrefixAllocations".equals(fieldName)) {
                    List ipamPoolPrefixAllocations;
                    deserializedSubnetPropertiesFormatInner.ipamPoolPrefixAllocations = ipamPoolPrefixAllocations = reader.readArray(reader1 -> IpamPoolPrefixAllocation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubnetPropertiesFormatInner;
        });
    }
}

