/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import com.azure.resourcemanager.network.fluent.models.VpnGatewayNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.VpnGatewayProperties;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnGatewayIpConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VpnGatewayInner
extends Resource {
    private VpnGatewayProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private VpnGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VpnGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public VpnGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VpnGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public VpnGatewayInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public List<VpnConnectionInner> connections() {
        return this.innerProperties() == null ? null : this.innerProperties().connections();
    }

    public VpnGatewayInner withConnections(List<VpnConnectionInner> connections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withConnections(connections);
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpSettings();
    }

    public VpnGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withBgpSettings(bgpSettings);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Integer vpnGatewayScaleUnit() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnGatewayScaleUnit();
    }

    public VpnGatewayInner withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withVpnGatewayScaleUnit(vpnGatewayScaleUnit);
        return this;
    }

    public List<VpnGatewayIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public Boolean enableBgpRouteTranslationForNat() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgpRouteTranslationForNat();
    }

    public VpnGatewayInner withEnableBgpRouteTranslationForNat(Boolean enableBgpRouteTranslationForNat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withEnableBgpRouteTranslationForNat(enableBgpRouteTranslationForNat);
        return this;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.innerProperties() == null ? null : this.innerProperties().isRoutingPreferenceInternet();
    }

    public VpnGatewayInner withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withIsRoutingPreferenceInternet(isRoutingPreferenceInternet);
        return this;
    }

    public List<VpnGatewayNatRuleInner> natRules() {
        return this.innerProperties() == null ? null : this.innerProperties().natRules();
    }

    public VpnGatewayInner withNatRules(List<VpnGatewayNatRuleInner> natRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnGatewayProperties();
        }
        this.innerProperties().withNatRules(natRules);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VpnGatewayInner fromJson(JsonReader jsonReader) throws IOException {
        return (VpnGatewayInner)((Object)jsonReader.readObject(reader -> {
            VpnGatewayInner deserializedVpnGatewayInner = new VpnGatewayInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVpnGatewayInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVpnGatewayInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVpnGatewayInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVpnGatewayInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVpnGatewayInner.innerProperties = VpnGatewayProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnGatewayInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVpnGatewayInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnGatewayInner;
        }));
    }
}

