/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GroupConnectivity;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.UseHubGateway;
import java.io.IOException;

public final class ConnectivityGroupItem
implements JsonSerializable<ConnectivityGroupItem> {
    private String networkGroupId;
    private UseHubGateway useHubGateway;
    private IsGlobal isGlobal;
    private GroupConnectivity groupConnectivity;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityGroupItem.class);

    public String networkGroupId() {
        return this.networkGroupId;
    }

    public ConnectivityGroupItem withNetworkGroupId(String networkGroupId) {
        this.networkGroupId = networkGroupId;
        return this;
    }

    public UseHubGateway useHubGateway() {
        return this.useHubGateway;
    }

    public ConnectivityGroupItem withUseHubGateway(UseHubGateway useHubGateway) {
        this.useHubGateway = useHubGateway;
        return this;
    }

    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    public ConnectivityGroupItem withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public GroupConnectivity groupConnectivity() {
        return this.groupConnectivity;
    }

    public ConnectivityGroupItem withGroupConnectivity(GroupConnectivity groupConnectivity) {
        this.groupConnectivity = groupConnectivity;
        return this;
    }

    public void validate() {
        if (this.networkGroupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkGroupId in model ConnectivityGroupItem"));
        }
        if (this.groupConnectivity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property groupConnectivity in model ConnectivityGroupItem"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkGroupId", this.networkGroupId);
        jsonWriter.writeStringField("groupConnectivity", this.groupConnectivity == null ? null : this.groupConnectivity.toString());
        jsonWriter.writeStringField("useHubGateway", this.useHubGateway == null ? null : this.useHubGateway.toString());
        jsonWriter.writeStringField("isGlobal", this.isGlobal == null ? null : this.isGlobal.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityGroupItem fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityGroupItem)jsonReader.readObject(reader -> {
            ConnectivityGroupItem deserializedConnectivityGroupItem = new ConnectivityGroupItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkGroupId".equals(fieldName)) {
                    deserializedConnectivityGroupItem.networkGroupId = reader.getString();
                    continue;
                }
                if ("groupConnectivity".equals(fieldName)) {
                    deserializedConnectivityGroupItem.groupConnectivity = GroupConnectivity.fromString(reader.getString());
                    continue;
                }
                if ("useHubGateway".equals(fieldName)) {
                    deserializedConnectivityGroupItem.useHubGateway = UseHubGateway.fromString(reader.getString());
                    continue;
                }
                if ("isGlobal".equals(fieldName)) {
                    deserializedConnectivityGroupItem.isGlobal = IsGlobal.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityGroupItem;
        });
    }
}

