// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Trusted client certificates properties of an application gateway.
 */
@Fluent
public final class ApplicationGatewayTrustedClientCertificatePropertiesFormat
    implements JsonSerializable<ApplicationGatewayTrustedClientCertificatePropertiesFormat> {
    /*
     * Certificate public data.
     */
    private String data;

    /*
     * Validated certificate data.
     */
    private String validatedCertData;

    /*
     * Distinguished name of client certificate issuer.
     */
    private String clientCertIssuerDN;

    /*
     * The provisioning state of the trusted client certificate resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayTrustedClientCertificatePropertiesFormat class.
     */
    public ApplicationGatewayTrustedClientCertificatePropertiesFormat() {
    }

    /**
     * Get the data property: Certificate public data.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: Certificate public data.
     * 
     * @param data the data value to set.
     * @return the ApplicationGatewayTrustedClientCertificatePropertiesFormat object itself.
     */
    public ApplicationGatewayTrustedClientCertificatePropertiesFormat withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the validatedCertData property: Validated certificate data.
     * 
     * @return the validatedCertData value.
     */
    public String validatedCertData() {
        return this.validatedCertData;
    }

    /**
     * Get the clientCertIssuerDN property: Distinguished name of client certificate issuer.
     * 
     * @return the clientCertIssuerDN value.
     */
    public String clientCertIssuerDN() {
        return this.clientCertIssuerDN;
    }

    /**
     * Get the provisioningState property: The provisioning state of the trusted client certificate resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("data", this.data);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayTrustedClientCertificatePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayTrustedClientCertificatePropertiesFormat if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayTrustedClientCertificatePropertiesFormat.
     */
    public static ApplicationGatewayTrustedClientCertificatePropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayTrustedClientCertificatePropertiesFormat deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat
                = new ApplicationGatewayTrustedClientCertificatePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("data".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat.data = reader.getString();
                } else if ("validatedCertData".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat.validatedCertData
                        = reader.getString();
                } else if ("clientCertIssuerDN".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat.clientCertIssuerDN
                        = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayTrustedClientCertificatePropertiesFormat;
        });
    }
}
