// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AuthorizationUseStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of ExpressRouteCircuitAuthorization.
 */
@Fluent
public final class AuthorizationPropertiesFormat implements JsonSerializable<AuthorizationPropertiesFormat> {
    /*
     * The authorization key.
     */
    private String authorizationKey;

    /*
     * The authorization use status.
     */
    private AuthorizationUseStatus authorizationUseStatus;

    /*
     * The reference to the ExpressRoute connection resource using the authorization.
     */
    private String connectionResourceUri;

    /*
     * The provisioning state of the authorization resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of AuthorizationPropertiesFormat class.
     */
    public AuthorizationPropertiesFormat() {
    }

    /**
     * Get the authorizationKey property: The authorization key.
     * 
     * @return the authorizationKey value.
     */
    public String authorizationKey() {
        return this.authorizationKey;
    }

    /**
     * Set the authorizationKey property: The authorization key.
     * 
     * @param authorizationKey the authorizationKey value to set.
     * @return the AuthorizationPropertiesFormat object itself.
     */
    public AuthorizationPropertiesFormat withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    /**
     * Get the authorizationUseStatus property: The authorization use status.
     * 
     * @return the authorizationUseStatus value.
     */
    public AuthorizationUseStatus authorizationUseStatus() {
        return this.authorizationUseStatus;
    }

    /**
     * Set the authorizationUseStatus property: The authorization use status.
     * 
     * @param authorizationUseStatus the authorizationUseStatus value to set.
     * @return the AuthorizationPropertiesFormat object itself.
     */
    public AuthorizationPropertiesFormat withAuthorizationUseStatus(AuthorizationUseStatus authorizationUseStatus) {
        this.authorizationUseStatus = authorizationUseStatus;
        return this;
    }

    /**
     * Get the connectionResourceUri property: The reference to the ExpressRoute connection resource using the
     * authorization.
     * 
     * @return the connectionResourceUri value.
     */
    public String connectionResourceUri() {
        return this.connectionResourceUri;
    }

    /**
     * Get the provisioningState property: The provisioning state of the authorization resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authorizationKey", this.authorizationKey);
        jsonWriter.writeStringField("authorizationUseStatus",
            this.authorizationUseStatus == null ? null : this.authorizationUseStatus.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationPropertiesFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationPropertiesFormat.
     */
    public static AuthorizationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationPropertiesFormat deserializedAuthorizationPropertiesFormat
                = new AuthorizationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authorizationKey".equals(fieldName)) {
                    deserializedAuthorizationPropertiesFormat.authorizationKey = reader.getString();
                } else if ("authorizationUseStatus".equals(fieldName)) {
                    deserializedAuthorizationPropertiesFormat.authorizationUseStatus
                        = AuthorizationUseStatus.fromString(reader.getString());
                } else if ("connectionResourceUri".equals(fieldName)) {
                    deserializedAuthorizationPropertiesFormat.connectionResourceUri = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAuthorizationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationPropertiesFormat;
        });
    }
}
