// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.BgpCommunity;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Service Community.
 */
@Fluent
public final class BgpServiceCommunityPropertiesFormat
    implements JsonSerializable<BgpServiceCommunityPropertiesFormat> {
    /*
     * The name of the bgp community. e.g. Skype.
     */
    private String serviceName;

    /*
     * A list of bgp communities.
     */
    private List<BgpCommunity> bgpCommunities;

    /**
     * Creates an instance of BgpServiceCommunityPropertiesFormat class.
     */
    public BgpServiceCommunityPropertiesFormat() {
    }

    /**
     * Get the serviceName property: The name of the bgp community. e.g. Skype.
     * 
     * @return the serviceName value.
     */
    public String serviceName() {
        return this.serviceName;
    }

    /**
     * Set the serviceName property: The name of the bgp community. e.g. Skype.
     * 
     * @param serviceName the serviceName value to set.
     * @return the BgpServiceCommunityPropertiesFormat object itself.
     */
    public BgpServiceCommunityPropertiesFormat withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * Get the bgpCommunities property: A list of bgp communities.
     * 
     * @return the bgpCommunities value.
     */
    public List<BgpCommunity> bgpCommunities() {
        return this.bgpCommunities;
    }

    /**
     * Set the bgpCommunities property: A list of bgp communities.
     * 
     * @param bgpCommunities the bgpCommunities value to set.
     * @return the BgpServiceCommunityPropertiesFormat object itself.
     */
    public BgpServiceCommunityPropertiesFormat withBgpCommunities(List<BgpCommunity> bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (bgpCommunities() != null) {
            bgpCommunities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeArrayField("bgpCommunities", this.bgpCommunities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpServiceCommunityPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpServiceCommunityPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BgpServiceCommunityPropertiesFormat.
     */
    public static BgpServiceCommunityPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpServiceCommunityPropertiesFormat deserializedBgpServiceCommunityPropertiesFormat
                = new BgpServiceCommunityPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceName".equals(fieldName)) {
                    deserializedBgpServiceCommunityPropertiesFormat.serviceName = reader.getString();
                } else if ("bgpCommunities".equals(fieldName)) {
                    List<BgpCommunity> bgpCommunities = reader.readArray(reader1 -> BgpCommunity.fromJson(reader1));
                    deserializedBgpServiceCommunityPropertiesFormat.bgpCommunities = bgpCommunities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpServiceCommunityPropertiesFormat;
        });
    }
}
