// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteFailoverCircuitResourceDetails;
import com.azure.resourcemanager.network.models.ExpressRouteFailoverConnectionResourceDetails;
import com.azure.resourcemanager.network.models.FailoverTestStatus;
import com.azure.resourcemanager.network.models.FailoverTestType;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRoute failover test details.
 */
@Fluent
public final class ExpressRouteFailoverTestDetailsInner
    implements JsonSerializable<ExpressRouteFailoverTestDetailsInner> {
    /*
     * Peering location of the test
     */
    private String peeringLocation;

    /*
     * All circuits in the peering location
     */
    private List<ExpressRouteFailoverCircuitResourceDetails> circuits;

    /*
     * The current status of the test
     */
    private FailoverTestStatus status;

    /*
     * Time when the test was started
     */
    private String startTime;

    /*
     * Time when the test was completed
     */
    private String endTime;

    /*
     * All connections to the circuits in the peering location
     */
    private List<ExpressRouteFailoverConnectionResourceDetails> connections;

    /*
     * The unique GUID associated with the test
     */
    private String testGuid;

    /*
     * The type of failover test
     */
    private FailoverTestType testType;

    /*
     * A list of all issues with the test
     */
    private List<String> issues;

    /**
     * Creates an instance of ExpressRouteFailoverTestDetailsInner class.
     */
    public ExpressRouteFailoverTestDetailsInner() {
    }

    /**
     * Get the peeringLocation property: Peering location of the test.
     * 
     * @return the peeringLocation value.
     */
    public String peeringLocation() {
        return this.peeringLocation;
    }

    /**
     * Set the peeringLocation property: Peering location of the test.
     * 
     * @param peeringLocation the peeringLocation value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    /**
     * Get the circuits property: All circuits in the peering location.
     * 
     * @return the circuits value.
     */
    public List<ExpressRouteFailoverCircuitResourceDetails> circuits() {
        return this.circuits;
    }

    /**
     * Set the circuits property: All circuits in the peering location.
     * 
     * @param circuits the circuits value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner
        withCircuits(List<ExpressRouteFailoverCircuitResourceDetails> circuits) {
        this.circuits = circuits;
        return this;
    }

    /**
     * Get the status property: The current status of the test.
     * 
     * @return the status value.
     */
    public FailoverTestStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of the test.
     * 
     * @param status the status value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withStatus(FailoverTestStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the startTime property: Time when the test was started.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Time when the test was started.
     * 
     * @param startTime the startTime value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: Time when the test was completed.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: Time when the test was completed.
     * 
     * @param endTime the endTime value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the connections property: All connections to the circuits in the peering location.
     * 
     * @return the connections value.
     */
    public List<ExpressRouteFailoverConnectionResourceDetails> connections() {
        return this.connections;
    }

    /**
     * Set the connections property: All connections to the circuits in the peering location.
     * 
     * @param connections the connections value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner
        withConnections(List<ExpressRouteFailoverConnectionResourceDetails> connections) {
        this.connections = connections;
        return this;
    }

    /**
     * Get the testGuid property: The unique GUID associated with the test.
     * 
     * @return the testGuid value.
     */
    public String testGuid() {
        return this.testGuid;
    }

    /**
     * Set the testGuid property: The unique GUID associated with the test.
     * 
     * @param testGuid the testGuid value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withTestGuid(String testGuid) {
        this.testGuid = testGuid;
        return this;
    }

    /**
     * Get the testType property: The type of failover test.
     * 
     * @return the testType value.
     */
    public FailoverTestType testType() {
        return this.testType;
    }

    /**
     * Set the testType property: The type of failover test.
     * 
     * @param testType the testType value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withTestType(FailoverTestType testType) {
        this.testType = testType;
        return this;
    }

    /**
     * Get the issues property: A list of all issues with the test.
     * 
     * @return the issues value.
     */
    public List<String> issues() {
        return this.issues;
    }

    /**
     * Set the issues property: A list of all issues with the test.
     * 
     * @param issues the issues value to set.
     * @return the ExpressRouteFailoverTestDetailsInner object itself.
     */
    public ExpressRouteFailoverTestDetailsInner withIssues(List<String> issues) {
        this.issues = issues;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (circuits() != null) {
            circuits().forEach(e -> e.validate());
        }
        if (connections() != null) {
            connections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peeringLocation", this.peeringLocation);
        jsonWriter.writeArrayField("circuits", this.circuits, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeArrayField("connections", this.connections, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("testGuid", this.testGuid);
        jsonWriter.writeStringField("testType", this.testType == null ? null : this.testType.toString());
        jsonWriter.writeArrayField("issues", this.issues, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteFailoverTestDetailsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteFailoverTestDetailsInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteFailoverTestDetailsInner.
     */
    public static ExpressRouteFailoverTestDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteFailoverTestDetailsInner deserializedExpressRouteFailoverTestDetailsInner
                = new ExpressRouteFailoverTestDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peeringLocation".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.peeringLocation = reader.getString();
                } else if ("circuits".equals(fieldName)) {
                    List<ExpressRouteFailoverCircuitResourceDetails> circuits
                        = reader.readArray(reader1 -> ExpressRouteFailoverCircuitResourceDetails.fromJson(reader1));
                    deserializedExpressRouteFailoverTestDetailsInner.circuits = circuits;
                } else if ("status".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.status
                        = FailoverTestStatus.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.startTime = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.endTime = reader.getString();
                } else if ("connections".equals(fieldName)) {
                    List<ExpressRouteFailoverConnectionResourceDetails> connections
                        = reader.readArray(reader1 -> ExpressRouteFailoverConnectionResourceDetails.fromJson(reader1));
                    deserializedExpressRouteFailoverTestDetailsInner.connections = connections;
                } else if ("testGuid".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.testGuid = reader.getString();
                } else if ("testType".equals(fieldName)) {
                    deserializedExpressRouteFailoverTestDetailsInner.testType
                        = FailoverTestType.fromString(reader.getString());
                } else if ("issues".equals(fieldName)) {
                    List<String> issues = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteFailoverTestDetailsInner.issues = issues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteFailoverTestDetailsInner;
        });
    }
}
