// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRoutePortAuthorizationUseStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * ExpressRoute Port Authorization Properties
 * 
 * Properties of ExpressRoutePort Authorization.
 */
@Immutable
public final class ExpressRoutePortAuthorizationPropertiesFormat
    implements JsonSerializable<ExpressRoutePortAuthorizationPropertiesFormat> {
    /*
     * The authorization key.
     */
    private String authorizationKey;

    /*
     * The authorization use status.
     */
    private ExpressRoutePortAuthorizationUseStatus authorizationUseStatus;

    /*
     * The reference to the ExpressRoute circuit resource using the authorization.
     */
    private String circuitResourceUri;

    /*
     * The provisioning state of the authorization resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ExpressRoutePortAuthorizationPropertiesFormat class.
     */
    public ExpressRoutePortAuthorizationPropertiesFormat() {
    }

    /**
     * Get the authorizationKey property: The authorization key.
     * 
     * @return the authorizationKey value.
     */
    public String authorizationKey() {
        return this.authorizationKey;
    }

    /**
     * Get the authorizationUseStatus property: The authorization use status.
     * 
     * @return the authorizationUseStatus value.
     */
    public ExpressRoutePortAuthorizationUseStatus authorizationUseStatus() {
        return this.authorizationUseStatus;
    }

    /**
     * Get the circuitResourceUri property: The reference to the ExpressRoute circuit resource using the authorization.
     * 
     * @return the circuitResourceUri value.
     */
    public String circuitResourceUri() {
        return this.circuitResourceUri;
    }

    /**
     * Get the provisioningState property: The provisioning state of the authorization resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRoutePortAuthorizationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRoutePortAuthorizationPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRoutePortAuthorizationPropertiesFormat.
     */
    public static ExpressRoutePortAuthorizationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortAuthorizationPropertiesFormat deserializedExpressRoutePortAuthorizationPropertiesFormat
                = new ExpressRoutePortAuthorizationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authorizationKey".equals(fieldName)) {
                    deserializedExpressRoutePortAuthorizationPropertiesFormat.authorizationKey = reader.getString();
                } else if ("authorizationUseStatus".equals(fieldName)) {
                    deserializedExpressRoutePortAuthorizationPropertiesFormat.authorizationUseStatus
                        = ExpressRoutePortAuthorizationUseStatus.fromString(reader.getString());
                } else if ("circuitResourceUri".equals(fieldName)) {
                    deserializedExpressRoutePortAuthorizationPropertiesFormat.circuitResourceUri = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRoutePortAuthorizationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRoutePortAuthorizationPropertiesFormat;
        });
    }
}
