// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonTrackedResource;
import com.azure.resourcemanager.network.models.IpamPoolProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Instance of Pool resource.
 */
@Fluent
public final class IpamPoolInner extends CommonTrackedResource {
    /*
     * Properties of IpamPool resource properties which are specific to the Pool resource.
     */
    private IpamPoolProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of IpamPoolInner class.
     */
    public IpamPoolInner() {
    }

    /**
     * Get the properties property: Properties of IpamPool resource properties which are specific to the Pool resource.
     * 
     * @return the properties value.
     */
    public IpamPoolProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of IpamPool resource properties which are specific to the Pool resource.
     * 
     * @param properties the properties value to set.
     * @return the IpamPoolInner object itself.
     */
    public IpamPoolInner withProperties(IpamPoolProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IpamPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IpamPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model IpamPoolInner"));
        } else {
            properties().validate();
        }
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property location in model IpamPoolInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IpamPoolInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IpamPoolInner.
     */
    public static IpamPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolInner deserializedIpamPoolInner = new IpamPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIpamPoolInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedIpamPoolInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIpamPoolInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedIpamPoolInner.withLocation(reader.getString());
                } else if ("systemData".equals(fieldName)) {
                    deserializedIpamPoolInner.systemData = SystemData.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpamPoolInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedIpamPoolInner.properties = IpamPoolProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolInner;
        });
    }
}
