// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The information about health per rule per backend address.
 */
@Fluent
public final class LoadBalancerHealthPerRulePerBackendAddressInner
    implements JsonSerializable<LoadBalancerHealthPerRulePerBackendAddressInner> {
    /*
     * The IP address belonging to the backend address.
     */
    private String ipAddress;

    /*
     * The id of the network interface ip configuration belonging to the backend address
     */
    private NetworkInterfaceIpConfigurationInner networkInterfaceIpConfigurationId;

    /*
     * The current health of the backend instances that is associated to the LB rule.
     */
    private String state;

    /*
     * The explanation of the State
     */
    private String reason;

    /**
     * Creates an instance of LoadBalancerHealthPerRulePerBackendAddressInner class.
     */
    public LoadBalancerHealthPerRulePerBackendAddressInner() {
    }

    /**
     * Get the ipAddress property: The IP address belonging to the backend address.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address belonging to the backend address.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddressInner object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddressInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the networkInterfaceIpConfigurationId property: The id of the network interface ip configuration belonging to
     * the backend address.
     * 
     * @return the networkInterfaceIpConfigurationId value.
     */
    public NetworkInterfaceIpConfigurationInner networkInterfaceIpConfigurationId() {
        return this.networkInterfaceIpConfigurationId;
    }

    /**
     * Set the networkInterfaceIpConfigurationId property: The id of the network interface ip configuration belonging to
     * the backend address.
     * 
     * @param networkInterfaceIpConfigurationId the networkInterfaceIpConfigurationId value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddressInner object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddressInner
        withNetworkInterfaceIpConfigurationId(NetworkInterfaceIpConfigurationInner networkInterfaceIpConfigurationId) {
        this.networkInterfaceIpConfigurationId = networkInterfaceIpConfigurationId;
        return this;
    }

    /**
     * Get the state property: The current health of the backend instances that is associated to the LB rule.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The current health of the backend instances that is associated to the LB rule.
     * 
     * @param state the state value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddressInner object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddressInner withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the reason property: The explanation of the State.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The explanation of the State.
     * 
     * @param reason the reason value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddressInner object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddressInner withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaceIpConfigurationId() != null) {
            networkInterfaceIpConfigurationId().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeJsonField("networkInterfaceIPConfigurationId", this.networkInterfaceIpConfigurationId);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerHealthPerRulePerBackendAddressInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerHealthPerRulePerBackendAddressInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerHealthPerRulePerBackendAddressInner.
     */
    public static LoadBalancerHealthPerRulePerBackendAddressInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerHealthPerRulePerBackendAddressInner deserializedLoadBalancerHealthPerRulePerBackendAddressInner
                = new LoadBalancerHealthPerRulePerBackendAddressInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddress".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddressInner.ipAddress = reader.getString();
                } else if ("networkInterfaceIPConfigurationId".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddressInner.networkInterfaceIpConfigurationId
                        = NetworkInterfaceIpConfigurationInner.fromJson(reader);
                } else if ("state".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddressInner.state = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddressInner.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerHealthPerRulePerBackendAddressInner;
        });
    }
}
