// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a list of virtual machine instance IDs from the Network Virtual Appliance VM instances.
 */
@Fluent
public final class NetworkVirtualApplianceInstanceIdsInner
    implements JsonSerializable<NetworkVirtualApplianceInstanceIdsInner> {
    /*
     * The network virtual appliance instance ids. Omitting the network virtual appliance instance ids will result in
     * the operation being performed on all virtual machines belonging to the network virtual appliance.
     */
    private List<String> instanceIds;

    /**
     * Creates an instance of NetworkVirtualApplianceInstanceIdsInner class.
     */
    public NetworkVirtualApplianceInstanceIdsInner() {
    }

    /**
     * Get the instanceIds property: The network virtual appliance instance ids. Omitting the network virtual appliance
     * instance ids will result in the operation being performed on all virtual machines belonging to the network
     * virtual appliance.
     * 
     * @return the instanceIds value.
     */
    public List<String> instanceIds() {
        return this.instanceIds;
    }

    /**
     * Set the instanceIds property: The network virtual appliance instance ids. Omitting the network virtual appliance
     * instance ids will result in the operation being performed on all virtual machines belonging to the network
     * virtual appliance.
     * 
     * @param instanceIds the instanceIds value to set.
     * @return the NetworkVirtualApplianceInstanceIdsInner object itself.
     */
    public NetworkVirtualApplianceInstanceIdsInner withInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("instanceIds", this.instanceIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkVirtualApplianceInstanceIdsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkVirtualApplianceInstanceIdsInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkVirtualApplianceInstanceIdsInner.
     */
    public static NetworkVirtualApplianceInstanceIdsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceInstanceIdsInner deserializedNetworkVirtualApplianceInstanceIdsInner
                = new NetworkVirtualApplianceInstanceIdsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceIds".equals(fieldName)) {
                    List<String> instanceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkVirtualApplianceInstanceIdsInner.instanceIds = instanceIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkVirtualApplianceInstanceIdsInner;
        });
    }
}
