// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureMachineScope;
import com.azure.resourcemanager.network.models.PacketCaptureSettings;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.azure.resourcemanager.network.models.PacketCaptureTargetType;
import java.io.IOException;
import java.util.List;

/**
 * Parameters that define the create packet capture operation.
 */
@Fluent
public class PacketCaptureParameters implements JsonSerializable<PacketCaptureParameters> {
    /*
     * The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
     */
    private String target;

    /*
     * A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and
     * excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    private PacketCaptureMachineScope scope;

    /*
     * Target type of the resource provided.
     */
    private PacketCaptureTargetType targetType;

    /*
     * Number of bytes captured per packet, the remaining bytes are truncated.
     */
    private Long bytesToCapturePerPacket;

    /*
     * Maximum size of the capture output.
     */
    private Long totalBytesPerSession;

    /*
     * Maximum duration of the capture session in seconds.
     */
    private Integer timeLimitInSeconds;

    /*
     * The storage location for a packet capture session.
     */
    private PacketCaptureStorageLocation storageLocation;

    /*
     * A list of packet capture filters.
     */
    private List<PacketCaptureFilter> filters;

    /*
     * This continuous capture is a nullable boolean, which can hold 'null', 'true' or 'false' value. If we do not pass
     * this parameter, it would be consider as 'null', default value is 'null'.
     */
    private Boolean continuousCapture;

    /*
     * The capture setting holds the 'FileCount', 'FileSizeInBytes', 'SessionTimeLimitInSeconds' values.
     */
    private PacketCaptureSettings captureSettings;

    /**
     * Creates an instance of PacketCaptureParameters class.
     */
    public PacketCaptureParameters() {
    }

    /**
     * Get the target property: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently
     * supported.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently
     * supported.
     * 
     * @param target the target value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the scope property: A list of AzureVMSS instances which can be included or excluded to run packet capture. If
     * both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     * 
     * @return the scope value.
     */
    public PacketCaptureMachineScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: A list of AzureVMSS instances which can be included or excluded to run packet capture. If
     * both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     * 
     * @param scope the scope value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withScope(PacketCaptureMachineScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the targetType property: Target type of the resource provided.
     * 
     * @return the targetType value.
     */
    public PacketCaptureTargetType targetType() {
        return this.targetType;
    }

    /**
     * Set the targetType property: Target type of the resource provided.
     * 
     * @param targetType the targetType value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTargetType(PacketCaptureTargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    /**
     * Get the bytesToCapturePerPacket property: Number of bytes captured per packet, the remaining bytes are truncated.
     * 
     * @return the bytesToCapturePerPacket value.
     */
    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    /**
     * Set the bytesToCapturePerPacket property: Number of bytes captured per packet, the remaining bytes are truncated.
     * 
     * @param bytesToCapturePerPacket the bytesToCapturePerPacket value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    /**
     * Get the totalBytesPerSession property: Maximum size of the capture output.
     * 
     * @return the totalBytesPerSession value.
     */
    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    /**
     * Set the totalBytesPerSession property: Maximum size of the capture output.
     * 
     * @param totalBytesPerSession the totalBytesPerSession value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    /**
     * Get the timeLimitInSeconds property: Maximum duration of the capture session in seconds.
     * 
     * @return the timeLimitInSeconds value.
     */
    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    /**
     * Set the timeLimitInSeconds property: Maximum duration of the capture session in seconds.
     * 
     * @param timeLimitInSeconds the timeLimitInSeconds value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    /**
     * Get the storageLocation property: The storage location for a packet capture session.
     * 
     * @return the storageLocation value.
     */
    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    /**
     * Set the storageLocation property: The storage location for a packet capture session.
     * 
     * @param storageLocation the storageLocation value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    /**
     * Get the filters property: A list of packet capture filters.
     * 
     * @return the filters value.
     */
    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: A list of packet capture filters.
     * 
     * @param filters the filters value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Get the continuousCapture property: This continuous capture is a nullable boolean, which can hold 'null', 'true'
     * or 'false' value. If we do not pass this parameter, it would be consider as 'null', default value is 'null'.
     * 
     * @return the continuousCapture value.
     */
    public Boolean continuousCapture() {
        return this.continuousCapture;
    }

    /**
     * Set the continuousCapture property: This continuous capture is a nullable boolean, which can hold 'null', 'true'
     * or 'false' value. If we do not pass this parameter, it would be consider as 'null', default value is 'null'.
     * 
     * @param continuousCapture the continuousCapture value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withContinuousCapture(Boolean continuousCapture) {
        this.continuousCapture = continuousCapture;
        return this;
    }

    /**
     * Get the captureSettings property: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     * 'SessionTimeLimitInSeconds' values.
     * 
     * @return the captureSettings value.
     */
    public PacketCaptureSettings captureSettings() {
        return this.captureSettings;
    }

    /**
     * Set the captureSettings property: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     * 'SessionTimeLimitInSeconds' values.
     * 
     * @param captureSettings the captureSettings value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withCaptureSettings(PacketCaptureSettings captureSettings) {
        this.captureSettings = captureSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (target() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property target in model PacketCaptureParameters"));
        }
        if (scope() != null) {
            scope().validate();
        }
        if (storageLocation() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageLocation in model PacketCaptureParameters"));
        } else {
            storageLocation().validate();
        }
        if (filters() != null) {
            filters().forEach(e -> e.validate());
        }
        if (captureSettings() != null) {
            captureSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PacketCaptureParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeJsonField("storageLocation", this.storageLocation);
        jsonWriter.writeJsonField("scope", this.scope);
        jsonWriter.writeStringField("targetType", this.targetType == null ? null : this.targetType.toString());
        jsonWriter.writeNumberField("bytesToCapturePerPacket", this.bytesToCapturePerPacket);
        jsonWriter.writeNumberField("totalBytesPerSession", this.totalBytesPerSession);
        jsonWriter.writeNumberField("timeLimitInSeconds", this.timeLimitInSeconds);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("continuousCapture", this.continuousCapture);
        jsonWriter.writeJsonField("captureSettings", this.captureSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PacketCaptureParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PacketCaptureParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PacketCaptureParameters.
     */
    public static PacketCaptureParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PacketCaptureParameters deserializedPacketCaptureParameters = new PacketCaptureParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("target".equals(fieldName)) {
                    deserializedPacketCaptureParameters.target = reader.getString();
                } else if ("storageLocation".equals(fieldName)) {
                    deserializedPacketCaptureParameters.storageLocation = PacketCaptureStorageLocation.fromJson(reader);
                } else if ("scope".equals(fieldName)) {
                    deserializedPacketCaptureParameters.scope = PacketCaptureMachineScope.fromJson(reader);
                } else if ("targetType".equals(fieldName)) {
                    deserializedPacketCaptureParameters.targetType
                        = PacketCaptureTargetType.fromString(reader.getString());
                } else if ("bytesToCapturePerPacket".equals(fieldName)) {
                    deserializedPacketCaptureParameters.bytesToCapturePerPacket
                        = reader.getNullable(JsonReader::getLong);
                } else if ("totalBytesPerSession".equals(fieldName)) {
                    deserializedPacketCaptureParameters.totalBytesPerSession = reader.getNullable(JsonReader::getLong);
                } else if ("timeLimitInSeconds".equals(fieldName)) {
                    deserializedPacketCaptureParameters.timeLimitInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("filters".equals(fieldName)) {
                    List<PacketCaptureFilter> filters
                        = reader.readArray(reader1 -> PacketCaptureFilter.fromJson(reader1));
                    deserializedPacketCaptureParameters.filters = filters;
                } else if ("continuousCapture".equals(fieldName)) {
                    deserializedPacketCaptureParameters.continuousCapture = reader.getNullable(JsonReader::getBoolean);
                } else if ("captureSettings".equals(fieldName)) {
                    deserializedPacketCaptureParameters.captureSettings = PacketCaptureSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPacketCaptureParameters;
        });
    }
}
