// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SingleQueryResult;
import java.io.IOException;
import java.util.List;

/**
 * Query result.
 */
@Fluent
public final class QueryResultsInner implements JsonSerializable<QueryResultsInner> {
    /*
     * Number of total records matching the query.
     */
    private Long matchingRecordsCount;

    /*
     * Array containing the results of the query
     */
    private List<SingleQueryResult> signatures;

    /**
     * Creates an instance of QueryResultsInner class.
     */
    public QueryResultsInner() {
    }

    /**
     * Get the matchingRecordsCount property: Number of total records matching the query.
     * 
     * @return the matchingRecordsCount value.
     */
    public Long matchingRecordsCount() {
        return this.matchingRecordsCount;
    }

    /**
     * Set the matchingRecordsCount property: Number of total records matching the query.
     * 
     * @param matchingRecordsCount the matchingRecordsCount value to set.
     * @return the QueryResultsInner object itself.
     */
    public QueryResultsInner withMatchingRecordsCount(Long matchingRecordsCount) {
        this.matchingRecordsCount = matchingRecordsCount;
        return this;
    }

    /**
     * Get the signatures property: Array containing the results of the query.
     * 
     * @return the signatures value.
     */
    public List<SingleQueryResult> signatures() {
        return this.signatures;
    }

    /**
     * Set the signatures property: Array containing the results of the query.
     * 
     * @param signatures the signatures value to set.
     * @return the QueryResultsInner object itself.
     */
    public QueryResultsInner withSignatures(List<SingleQueryResult> signatures) {
        this.signatures = signatures;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (signatures() != null) {
            signatures().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("matchingRecordsCount", this.matchingRecordsCount);
        jsonWriter.writeArrayField("signatures", this.signatures, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryResultsInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryResultsInner.
     */
    public static QueryResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryResultsInner deserializedQueryResultsInner = new QueryResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("matchingRecordsCount".equals(fieldName)) {
                    deserializedQueryResultsInner.matchingRecordsCount = reader.getNullable(JsonReader::getLong);
                } else if ("signatures".equals(fieldName)) {
                    List<SingleQueryResult> signatures
                        = reader.readArray(reader1 -> SingleQueryResult.fromJson(reader1));
                    deserializedQueryResultsInner.signatures = signatures;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryResultsInner;
        });
    }
}
