// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DisableBgpRoutePropagation;
import com.azure.resourcemanager.network.models.NetworkManagerRoutingGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Defines the routing rule collection properties.
 */
@Fluent
public final class RoutingRuleCollectionPropertiesFormat
    implements JsonSerializable<RoutingRuleCollectionPropertiesFormat> {
    /*
     * A description of the routing rule collection.
     */
    private String description;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /*
     * Groups for configuration
     */
    private List<NetworkManagerRoutingGroupItem> appliesTo;

    /*
     * Determines whether BGP route propagation is enabled. Defaults to true.
     */
    private DisableBgpRoutePropagation disableBgpRoutePropagation;

    /**
     * Creates an instance of RoutingRuleCollectionPropertiesFormat class.
     */
    public RoutingRuleCollectionPropertiesFormat() {
    }

    /**
     * Get the description property: A description of the routing rule collection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the routing rule collection.
     * 
     * @param description the description value to set.
     * @return the RoutingRuleCollectionPropertiesFormat object itself.
     */
    public RoutingRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the appliesTo property: Groups for configuration.
     * 
     * @return the appliesTo value.
     */
    public List<NetworkManagerRoutingGroupItem> appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: Groups for configuration.
     * 
     * @param appliesTo the appliesTo value to set.
     * @return the RoutingRuleCollectionPropertiesFormat object itself.
     */
    public RoutingRuleCollectionPropertiesFormat withAppliesTo(List<NetworkManagerRoutingGroupItem> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the disableBgpRoutePropagation property: Determines whether BGP route propagation is enabled. Defaults to
     * true.
     * 
     * @return the disableBgpRoutePropagation value.
     */
    public DisableBgpRoutePropagation disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    /**
     * Set the disableBgpRoutePropagation property: Determines whether BGP route propagation is enabled. Defaults to
     * true.
     * 
     * @param disableBgpRoutePropagation the disableBgpRoutePropagation value to set.
     * @return the RoutingRuleCollectionPropertiesFormat object itself.
     */
    public RoutingRuleCollectionPropertiesFormat
        withDisableBgpRoutePropagation(DisableBgpRoutePropagation disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appliesTo() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property appliesTo in model RoutingRuleCollectionPropertiesFormat"));
        } else {
            appliesTo().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutingRuleCollectionPropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesTo", this.appliesTo, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("disableBgpRoutePropagation",
            this.disableBgpRoutePropagation == null ? null : this.disableBgpRoutePropagation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleCollectionPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleCollectionPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRuleCollectionPropertiesFormat.
     */
    public static RoutingRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleCollectionPropertiesFormat deserializedRoutingRuleCollectionPropertiesFormat
                = new RoutingRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appliesTo".equals(fieldName)) {
                    List<NetworkManagerRoutingGroupItem> appliesTo
                        = reader.readArray(reader1 -> NetworkManagerRoutingGroupItem.fromJson(reader1));
                    deserializedRoutingRuleCollectionPropertiesFormat.appliesTo = appliesTo;
                } else if ("description".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                } else if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.disableBgpRoutePropagation
                        = DisableBgpRoutePropagation.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleCollectionPropertiesFormat;
        });
    }
}
