// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingRuleNextHop;
import com.azure.resourcemanager.network.models.RoutingRuleRouteDestination;
import java.io.IOException;

/**
 * Network routing rule.
 */
@Fluent
public final class RoutingRuleInner extends ChildResource {
    /*
     * Indicates the properties of the routing rule
     */
    private RoutingRulePropertiesFormat innerProperties;

    /*
     * The system metadata related to this resource.
     */
    private SystemData systemData;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RoutingRuleInner class.
     */
    public RoutingRuleInner() {
    }

    /**
     * Get the innerProperties property: Indicates the properties of the routing rule.
     * 
     * @return the innerProperties value.
     */
    private RoutingRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: A description for this rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description for this rule.
     * 
     * @param description the description value to set.
     * @return the RoutingRuleInner object itself.
     */
    public RoutingRuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRulePropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the destination property: Indicates the destination for this particular rule.
     * 
     * @return the destination value.
     */
    public RoutingRuleRouteDestination destination() {
        return this.innerProperties() == null ? null : this.innerProperties().destination();
    }

    /**
     * Set the destination property: Indicates the destination for this particular rule.
     * 
     * @param destination the destination value to set.
     * @return the RoutingRuleInner object itself.
     */
    public RoutingRuleInner withDestination(RoutingRuleRouteDestination destination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRulePropertiesFormat();
        }
        this.innerProperties().withDestination(destination);
        return this;
    }

    /**
     * Get the nextHop property: Indicates the next hop for this particular rule.
     * 
     * @return the nextHop value.
     */
    public RoutingRuleNextHop nextHop() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHop();
    }

    /**
     * Set the nextHop property: Indicates the next hop for this particular rule.
     * 
     * @param nextHop the nextHop value to set.
     * @return the RoutingRuleInner object itself.
     */
    public RoutingRuleInner withNextHop(RoutingRuleNextHop nextHop) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRulePropertiesFormat();
        }
        this.innerProperties().withNextHop(nextHop);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRuleInner.
     */
    public static RoutingRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleInner deserializedRoutingRuleInner = new RoutingRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoutingRuleInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoutingRuleInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoutingRuleInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedRoutingRuleInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoutingRuleInner.innerProperties = RoutingRulePropertiesFormat.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedRoutingRuleInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleInner;
        });
    }
}
