// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of VirtualNetworkGatewayIPConfiguration.
 */
@Fluent
public final class VirtualNetworkGatewayIpConfigurationPropertiesFormat
    implements JsonSerializable<VirtualNetworkGatewayIpConfigurationPropertiesFormat> {
    /*
     * The private IP address allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * The reference to the subnet resource.
     */
    private SubResource subnet;

    /*
     * The reference to the public IP resource.
     */
    private SubResource publicIpAddress;

    /*
     * Private IP Address for this gateway.
     */
    private String privateIpAddress;

    /*
     * The provisioning state of the virtual network gateway IP configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VirtualNetworkGatewayIpConfigurationPropertiesFormat class.
     */
    public VirtualNetworkGatewayIpConfigurationPropertiesFormat() {
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the VirtualNetworkGatewayIpConfigurationPropertiesFormat object itself.
     */
    public VirtualNetworkGatewayIpConfigurationPropertiesFormat
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the subnet property: The reference to the subnet resource.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource.
     * 
     * @param subnet the subnet value to set.
     * @return the VirtualNetworkGatewayIpConfigurationPropertiesFormat object itself.
     */
    public VirtualNetworkGatewayIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: The reference to the public IP resource.
     * 
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: The reference to the public IP resource.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the VirtualNetworkGatewayIpConfigurationPropertiesFormat object itself.
     */
    public VirtualNetworkGatewayIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the privateIpAddress property: Private IP Address for this gateway.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual network gateway IP configuration
     * resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayIpConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayIpConfigurationPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayIpConfigurationPropertiesFormat.
     */
    public static VirtualNetworkGatewayIpConfigurationPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayIpConfigurationPropertiesFormat deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat
                = new VirtualNetworkGatewayIpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat.subnet
                        = SubResource.fromJson(reader);
                } else if ("publicIPAddress".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat.publicIpAddress
                        = SubResource.fromJson(reader);
                } else if ("privateIPAddress".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat.privateIpAddress
                        = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayIpConfigurationPropertiesFormat;
        });
    }
}
