// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Virtual Network Tap properties.
 */
@Fluent
public final class VirtualNetworkTapPropertiesFormatInner
    implements JsonSerializable<VirtualNetworkTapPropertiesFormatInner> {
    /*
     * Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
     */
    private List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations;

    /*
     * The resource GUID property of the virtual network tap resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the virtual network tap resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The reference to the private IP Address of the collector nic that will receive the tap.
     */
    private NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration;

    /*
     * The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    private FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration;

    /*
     * The VXLAN destination port that will receive the tapped traffic.
     */
    private Integer destinationPort;

    /**
     * Creates an instance of VirtualNetworkTapPropertiesFormatInner class.
     */
    public VirtualNetworkTapPropertiesFormatInner() {
    }

    /**
     * Get the networkInterfaceTapConfigurations property: Specifies the list of resource IDs for the network interface
     * IP configuration that needs to be tapped.
     * 
     * @return the networkInterfaceTapConfigurations value.
     */
    public List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations() {
        return this.networkInterfaceTapConfigurations;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the virtual network tap resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual network tap resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the destinationNetworkInterfaceIpConfiguration property: The reference to the private IP Address of the
     * collector nic that will receive the tap.
     * 
     * @return the destinationNetworkInterfaceIpConfiguration value.
     */
    public NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration() {
        return this.destinationNetworkInterfaceIpConfiguration;
    }

    /**
     * Set the destinationNetworkInterfaceIpConfiguration property: The reference to the private IP Address of the
     * collector nic that will receive the tap.
     * 
     * @param destinationNetworkInterfaceIpConfiguration the destinationNetworkInterfaceIpConfiguration value to set.
     * @return the VirtualNetworkTapPropertiesFormatInner object itself.
     */
    public VirtualNetworkTapPropertiesFormatInner withDestinationNetworkInterfaceIpConfiguration(
        NetworkInterfaceIpConfigurationInner destinationNetworkInterfaceIpConfiguration) {
        this.destinationNetworkInterfaceIpConfiguration = destinationNetworkInterfaceIpConfiguration;
        return this;
    }

    /**
     * Get the destinationLoadBalancerFrontEndIpConfiguration property: The reference to the private IP address on the
     * internal Load Balancer that will receive the tap.
     * 
     * @return the destinationLoadBalancerFrontEndIpConfiguration value.
     */
    public FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration() {
        return this.destinationLoadBalancerFrontEndIpConfiguration;
    }

    /**
     * Set the destinationLoadBalancerFrontEndIpConfiguration property: The reference to the private IP address on the
     * internal Load Balancer that will receive the tap.
     * 
     * @param destinationLoadBalancerFrontEndIpConfiguration the destinationLoadBalancerFrontEndIpConfiguration value to
     * set.
     * @return the VirtualNetworkTapPropertiesFormatInner object itself.
     */
    public VirtualNetworkTapPropertiesFormatInner withDestinationLoadBalancerFrontEndIpConfiguration(
        FrontendIpConfigurationInner destinationLoadBalancerFrontEndIpConfiguration) {
        this.destinationLoadBalancerFrontEndIpConfiguration = destinationLoadBalancerFrontEndIpConfiguration;
        return this;
    }

    /**
     * Get the destinationPort property: The VXLAN destination port that will receive the tapped traffic.
     * 
     * @return the destinationPort value.
     */
    public Integer destinationPort() {
        return this.destinationPort;
    }

    /**
     * Set the destinationPort property: The VXLAN destination port that will receive the tapped traffic.
     * 
     * @param destinationPort the destinationPort value to set.
     * @return the VirtualNetworkTapPropertiesFormatInner object itself.
     */
    public VirtualNetworkTapPropertiesFormatInner withDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaceTapConfigurations() != null) {
            networkInterfaceTapConfigurations().forEach(e -> e.validate());
        }
        if (destinationNetworkInterfaceIpConfiguration() != null) {
            destinationNetworkInterfaceIpConfiguration().validate();
        }
        if (destinationLoadBalancerFrontEndIpConfiguration() != null) {
            destinationLoadBalancerFrontEndIpConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destinationNetworkInterfaceIPConfiguration",
            this.destinationNetworkInterfaceIpConfiguration);
        jsonWriter.writeJsonField("destinationLoadBalancerFrontEndIPConfiguration",
            this.destinationLoadBalancerFrontEndIpConfiguration);
        jsonWriter.writeNumberField("destinationPort", this.destinationPort);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkTapPropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkTapPropertiesFormatInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkTapPropertiesFormatInner.
     */
    public static VirtualNetworkTapPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkTapPropertiesFormatInner deserializedVirtualNetworkTapPropertiesFormatInner
                = new VirtualNetworkTapPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkInterfaceTapConfigurations".equals(fieldName)) {
                    List<NetworkInterfaceTapConfigurationInner> networkInterfaceTapConfigurations
                        = reader.readArray(reader1 -> NetworkInterfaceTapConfigurationInner.fromJson(reader1));
                    deserializedVirtualNetworkTapPropertiesFormatInner.networkInterfaceTapConfigurations
                        = networkInterfaceTapConfigurations;
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("destinationNetworkInterfaceIPConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationNetworkInterfaceIpConfiguration
                        = NetworkInterfaceIpConfigurationInner.fromJson(reader);
                } else if ("destinationLoadBalancerFrontEndIPConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationLoadBalancerFrontEndIpConfiguration
                        = FrontendIpConfigurationInner.fromJson(reader);
                } else if ("destinationPort".equals(fieldName)) {
                    deserializedVirtualNetworkTapPropertiesFormatInner.destinationPort
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkTapPropertiesFormatInner;
        });
    }
}
