// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of the rule group.
 */
@Fluent
public final class VirtualRouterPeeringProperties implements JsonSerializable<VirtualRouterPeeringProperties> {
    /*
     * Peer ASN.
     */
    private Long peerAsn;

    /*
     * Peer IP.
     */
    private String peerIp;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VirtualRouterPeeringProperties class.
     */
    public VirtualRouterPeeringProperties() {
    }

    /**
     * Get the peerAsn property: Peer ASN.
     * 
     * @return the peerAsn value.
     */
    public Long peerAsn() {
        return this.peerAsn;
    }

    /**
     * Set the peerAsn property: Peer ASN.
     * 
     * @param peerAsn the peerAsn value to set.
     * @return the VirtualRouterPeeringProperties object itself.
     */
    public VirtualRouterPeeringProperties withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    /**
     * Get the peerIp property: Peer IP.
     * 
     * @return the peerIp value.
     */
    public String peerIp() {
        return this.peerIp;
    }

    /**
     * Set the peerIp property: Peer IP.
     * 
     * @param peerIp the peerIp value to set.
     * @return the VirtualRouterPeeringProperties object itself.
     */
    public VirtualRouterPeeringProperties withPeerIp(String peerIp) {
        this.peerIp = peerIp;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("peerAsn", this.peerAsn);
        jsonWriter.writeStringField("peerIp", this.peerIp);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualRouterPeeringProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualRouterPeeringProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualRouterPeeringProperties.
     */
    public static VirtualRouterPeeringProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualRouterPeeringProperties deserializedVirtualRouterPeeringProperties
                = new VirtualRouterPeeringProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peerAsn".equals(fieldName)) {
                    deserializedVirtualRouterPeeringProperties.peerAsn = reader.getNullable(JsonReader::getLong);
                } else if ("peerIp".equals(fieldName)) {
                    deserializedVirtualRouterPeeringProperties.peerIp = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualRouterPeeringProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualRouterPeeringProperties;
        });
    }
}
