// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Option indicating the update behavior of a resource's address prefixes referenced within a network manager
 * configuration.
 */
public final class AddressSpaceAggregationOption extends ExpandableStringEnum<AddressSpaceAggregationOption> {
    /**
     * Static value None for AddressSpaceAggregationOption.
     */
    public static final AddressSpaceAggregationOption NONE = fromString("None");

    /**
     * Static value Manual for AddressSpaceAggregationOption.
     */
    public static final AddressSpaceAggregationOption MANUAL = fromString("Manual");

    /**
     * Creates a new instance of AddressSpaceAggregationOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AddressSpaceAggregationOption() {
    }

    /**
     * Creates or finds a AddressSpaceAggregationOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AddressSpaceAggregationOption.
     */
    public static AddressSpaceAggregationOption fromString(String name) {
        return fromString(name, AddressSpaceAggregationOption.class);
    }

    /**
     * Gets known AddressSpaceAggregationOption values.
     * 
     * @return known AddressSpaceAggregationOption values.
     */
    public static Collection<AddressSpaceAggregationOption> values() {
        return values(AddressSpaceAggregationOption.class);
    }
}
