// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayPrivateLinkConfigurationProperties;
import java.io.IOException;
import java.util.List;

/**
 * Private Link Configuration on an application gateway.
 */
@Fluent
public final class ApplicationGatewayPrivateLinkConfiguration extends SubResource {
    /*
     * Properties of the application gateway private link configuration.
     */
    private ApplicationGatewayPrivateLinkConfigurationProperties innerProperties;

    /*
     * Name of the private link configuration that is unique within an Application Gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ApplicationGatewayPrivateLinkConfiguration class.
     */
    public ApplicationGatewayPrivateLinkConfiguration() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway private link configuration.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayPrivateLinkConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the private link configuration that is unique within an Application Gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the private link configuration that is unique within an Application Gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayPrivateLinkConfiguration object itself.
     */
    public ApplicationGatewayPrivateLinkConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayPrivateLinkConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the ipConfigurations property: An array of application gateway private link ip configurations.
     * 
     * @return the ipConfigurations value.
     */
    public List<ApplicationGatewayPrivateLinkIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    /**
     * Set the ipConfigurations property: An array of application gateway private link ip configurations.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the ApplicationGatewayPrivateLinkConfiguration object itself.
     */
    public ApplicationGatewayPrivateLinkConfiguration
        withIpConfigurations(List<ApplicationGatewayPrivateLinkIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateLinkConfigurationProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the application gateway private link configuration.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayPrivateLinkConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayPrivateLinkConfiguration if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayPrivateLinkConfiguration.
     */
    public static ApplicationGatewayPrivateLinkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateLinkConfiguration deserializedApplicationGatewayPrivateLinkConfiguration
                = new ApplicationGatewayPrivateLinkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkConfiguration.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkConfiguration.innerProperties
                        = ApplicationGatewayPrivateLinkConfigurationProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkConfiguration.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkConfiguration.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkConfiguration.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayPrivateLinkConfiguration;
        });
    }
}
