// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application gateway web application firewall configuration.
 */
@Fluent
public final class ApplicationGatewayWebApplicationFirewallConfiguration
    implements JsonSerializable<ApplicationGatewayWebApplicationFirewallConfiguration> {
    /*
     * Whether the web application firewall is enabled or not.
     */
    private boolean enabled;

    /*
     * Web application firewall mode.
     */
    private ApplicationGatewayFirewallMode firewallMode;

    /*
     * The type of the web application firewall rule set. Possible values are: 'OWASP'.
     */
    private String ruleSetType;

    /*
     * The version of the rule set type.
     */
    private String ruleSetVersion;

    /*
     * The disabled rule groups.
     */
    private List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups;

    /*
     * Whether allow WAF to check request Body.
     */
    private Boolean requestBodyCheck;

    /*
     * Maximum request body size for WAF.
     */
    private Integer maxRequestBodySize;

    /*
     * Maximum request body size in Kb for WAF.
     */
    private Integer maxRequestBodySizeInKb;

    /*
     * Maximum file upload size in Mb for WAF.
     */
    private Integer fileUploadLimitInMb;

    /*
     * The exclusion list.
     */
    private List<ApplicationGatewayFirewallExclusion> exclusions;

    /**
     * Creates an instance of ApplicationGatewayWebApplicationFirewallConfiguration class.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration() {
    }

    /**
     * Get the enabled property: Whether the web application firewall is enabled or not.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether the web application firewall is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the firewallMode property: Web application firewall mode.
     * 
     * @return the firewallMode value.
     */
    public ApplicationGatewayFirewallMode firewallMode() {
        return this.firewallMode;
    }

    /**
     * Set the firewallMode property: Web application firewall mode.
     * 
     * @param firewallMode the firewallMode value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration
        withFirewallMode(ApplicationGatewayFirewallMode firewallMode) {
        this.firewallMode = firewallMode;
        return this;
    }

    /**
     * Get the ruleSetType property: The type of the web application firewall rule set. Possible values are: 'OWASP'.
     * 
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.ruleSetType;
    }

    /**
     * Set the ruleSetType property: The type of the web application firewall rule set. Possible values are: 'OWASP'.
     * 
     * @param ruleSetType the ruleSetType value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    /**
     * Get the ruleSetVersion property: The version of the rule set type.
     * 
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    /**
     * Set the ruleSetVersion property: The version of the rule set type.
     * 
     * @param ruleSetVersion the ruleSetVersion value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    /**
     * Get the disabledRuleGroups property: The disabled rule groups.
     * 
     * @return the disabledRuleGroups value.
     */
    public List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups() {
        return this.disabledRuleGroups;
    }

    /**
     * Set the disabledRuleGroups property: The disabled rule groups.
     * 
     * @param disabledRuleGroups the disabledRuleGroups value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration
        withDisabledRuleGroups(List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups) {
        this.disabledRuleGroups = disabledRuleGroups;
        return this;
    }

    /**
     * Get the requestBodyCheck property: Whether allow WAF to check request Body.
     * 
     * @return the requestBodyCheck value.
     */
    public Boolean requestBodyCheck() {
        return this.requestBodyCheck;
    }

    /**
     * Set the requestBodyCheck property: Whether allow WAF to check request Body.
     * 
     * @param requestBodyCheck the requestBodyCheck value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withRequestBodyCheck(Boolean requestBodyCheck) {
        this.requestBodyCheck = requestBodyCheck;
        return this;
    }

    /**
     * Get the maxRequestBodySize property: Maximum request body size for WAF.
     * 
     * @return the maxRequestBodySize value.
     */
    public Integer maxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    /**
     * Set the maxRequestBodySize property: Maximum request body size for WAF.
     * 
     * @param maxRequestBodySize the maxRequestBodySize value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withMaxRequestBodySize(Integer maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
        return this;
    }

    /**
     * Get the maxRequestBodySizeInKb property: Maximum request body size in Kb for WAF.
     * 
     * @return the maxRequestBodySizeInKb value.
     */
    public Integer maxRequestBodySizeInKb() {
        return this.maxRequestBodySizeInKb;
    }

    /**
     * Set the maxRequestBodySizeInKb property: Maximum request body size in Kb for WAF.
     * 
     * @param maxRequestBodySizeInKb the maxRequestBodySizeInKb value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration
        withMaxRequestBodySizeInKb(Integer maxRequestBodySizeInKb) {
        this.maxRequestBodySizeInKb = maxRequestBodySizeInKb;
        return this;
    }

    /**
     * Get the fileUploadLimitInMb property: Maximum file upload size in Mb for WAF.
     * 
     * @return the fileUploadLimitInMb value.
     */
    public Integer fileUploadLimitInMb() {
        return this.fileUploadLimitInMb;
    }

    /**
     * Set the fileUploadLimitInMb property: Maximum file upload size in Mb for WAF.
     * 
     * @param fileUploadLimitInMb the fileUploadLimitInMb value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration withFileUploadLimitInMb(Integer fileUploadLimitInMb) {
        this.fileUploadLimitInMb = fileUploadLimitInMb;
        return this;
    }

    /**
     * Get the exclusions property: The exclusion list.
     * 
     * @return the exclusions value.
     */
    public List<ApplicationGatewayFirewallExclusion> exclusions() {
        return this.exclusions;
    }

    /**
     * Set the exclusions property: The exclusion list.
     * 
     * @param exclusions the exclusions value to set.
     * @return the ApplicationGatewayWebApplicationFirewallConfiguration object itself.
     */
    public ApplicationGatewayWebApplicationFirewallConfiguration
        withExclusions(List<ApplicationGatewayFirewallExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (firewallMode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property firewallMode in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (ruleSetType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleSetType in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (ruleSetVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleSetVersion in model ApplicationGatewayWebApplicationFirewallConfiguration"));
        }
        if (disabledRuleGroups() != null) {
            disabledRuleGroups().forEach(e -> e.validate());
        }
        if (exclusions() != null) {
            exclusions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(ApplicationGatewayWebApplicationFirewallConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("firewallMode", this.firewallMode == null ? null : this.firewallMode.toString());
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("disabledRuleGroups", this.disabledRuleGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("requestBodyCheck", this.requestBodyCheck);
        jsonWriter.writeNumberField("maxRequestBodySize", this.maxRequestBodySize);
        jsonWriter.writeNumberField("maxRequestBodySizeInKb", this.maxRequestBodySizeInKb);
        jsonWriter.writeNumberField("fileUploadLimitInMb", this.fileUploadLimitInMb);
        jsonWriter.writeArrayField("exclusions", this.exclusions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayWebApplicationFirewallConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayWebApplicationFirewallConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayWebApplicationFirewallConfiguration.
     */
    public static ApplicationGatewayWebApplicationFirewallConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayWebApplicationFirewallConfiguration deserializedApplicationGatewayWebApplicationFirewallConfiguration
                = new ApplicationGatewayWebApplicationFirewallConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.enabled = reader.getBoolean();
                } else if ("firewallMode".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.firewallMode
                        = ApplicationGatewayFirewallMode.fromString(reader.getString());
                } else if ("ruleSetType".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.ruleSetType = reader.getString();
                } else if ("ruleSetVersion".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.ruleSetVersion
                        = reader.getString();
                } else if ("disabledRuleGroups".equals(fieldName)) {
                    List<ApplicationGatewayFirewallDisabledRuleGroup> disabledRuleGroups
                        = reader.readArray(reader1 -> ApplicationGatewayFirewallDisabledRuleGroup.fromJson(reader1));
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.disabledRuleGroups
                        = disabledRuleGroups;
                } else if ("requestBodyCheck".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.requestBodyCheck
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("maxRequestBodySize".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.maxRequestBodySize
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxRequestBodySizeInKb".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.maxRequestBodySizeInKb
                        = reader.getNullable(JsonReader::getInt);
                } else if ("fileUploadLimitInMb".equals(fieldName)) {
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.fileUploadLimitInMb
                        = reader.getNullable(JsonReader::getInt);
                } else if ("exclusions".equals(fieldName)) {
                    List<ApplicationGatewayFirewallExclusion> exclusions
                        = reader.readArray(reader1 -> ApplicationGatewayFirewallExclusion.fromJson(reader1));
                    deserializedApplicationGatewayWebApplicationFirewallConfiguration.exclusions = exclusions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayWebApplicationFirewallConfiguration;
        });
    }
}
