// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of an application rule.
 */
@Fluent
public final class AzureFirewallApplicationRule implements JsonSerializable<AzureFirewallApplicationRule> {
    /*
     * Name of the application rule.
     */
    private String name;

    /*
     * Description of the rule.
     */
    private String description;

    /*
     * List of source IP addresses for this rule.
     */
    private List<String> sourceAddresses;

    /*
     * Array of ApplicationRuleProtocols.
     */
    private List<AzureFirewallApplicationRuleProtocol> protocols;

    /*
     * List of FQDNs for this rule.
     */
    private List<String> targetFqdns;

    /*
     * List of FQDN Tags for this rule.
     */
    private List<String> fqdnTags;

    /*
     * List of source IpGroups for this rule.
     */
    private List<String> sourceIpGroups;

    /**
     * Creates an instance of AzureFirewallApplicationRule class.
     */
    public AzureFirewallApplicationRule() {
    }

    /**
     * Get the name property: Name of the application rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the application rule.
     * 
     * @param name the name value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Description of the rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the rule.
     * 
     * @param description the description value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the sourceAddresses property: List of source IP addresses for this rule.
     * 
     * @return the sourceAddresses value.
     */
    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    /**
     * Set the sourceAddresses property: List of source IP addresses for this rule.
     * 
     * @param sourceAddresses the sourceAddresses value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    /**
     * Get the protocols property: Array of ApplicationRuleProtocols.
     * 
     * @return the protocols value.
     */
    public List<AzureFirewallApplicationRuleProtocol> protocols() {
        return this.protocols;
    }

    /**
     * Set the protocols property: Array of ApplicationRuleProtocols.
     * 
     * @param protocols the protocols value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withProtocols(List<AzureFirewallApplicationRuleProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    /**
     * Get the targetFqdns property: List of FQDNs for this rule.
     * 
     * @return the targetFqdns value.
     */
    public List<String> targetFqdns() {
        return this.targetFqdns;
    }

    /**
     * Set the targetFqdns property: List of FQDNs for this rule.
     * 
     * @param targetFqdns the targetFqdns value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withTargetFqdns(List<String> targetFqdns) {
        this.targetFqdns = targetFqdns;
        return this;
    }

    /**
     * Get the fqdnTags property: List of FQDN Tags for this rule.
     * 
     * @return the fqdnTags value.
     */
    public List<String> fqdnTags() {
        return this.fqdnTags;
    }

    /**
     * Set the fqdnTags property: List of FQDN Tags for this rule.
     * 
     * @param fqdnTags the fqdnTags value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withFqdnTags(List<String> fqdnTags) {
        this.fqdnTags = fqdnTags;
        return this;
    }

    /**
     * Get the sourceIpGroups property: List of source IpGroups for this rule.
     * 
     * @return the sourceIpGroups value.
     */
    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    /**
     * Set the sourceIpGroups property: List of source IpGroups for this rule.
     * 
     * @param sourceIpGroups the sourceIpGroups value to set.
     * @return the AzureFirewallApplicationRule object itself.
     */
    public AzureFirewallApplicationRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (protocols() != null) {
            protocols().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("targetFqdns", this.targetFqdns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fqdnTags", this.fqdnTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallApplicationRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallApplicationRule if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallApplicationRule.
     */
    public static AzureFirewallApplicationRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallApplicationRule deserializedAzureFirewallApplicationRule = new AzureFirewallApplicationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRule.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRule.description = reader.getString();
                } else if ("sourceAddresses".equals(fieldName)) {
                    List<String> sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.sourceAddresses = sourceAddresses;
                } else if ("protocols".equals(fieldName)) {
                    List<AzureFirewallApplicationRuleProtocol> protocols
                        = reader.readArray(reader1 -> AzureFirewallApplicationRuleProtocol.fromJson(reader1));
                    deserializedAzureFirewallApplicationRule.protocols = protocols;
                } else if ("targetFqdns".equals(fieldName)) {
                    List<String> targetFqdns = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.targetFqdns = targetFqdns;
                } else if ("fqdnTags".equals(fieldName)) {
                    List<String> fqdnTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.fqdnTags = fqdnTags;
                } else if ("sourceIpGroups".equals(fieldName)) {
                    List<String> sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirewallApplicationRule.sourceIpGroups = sourceIpGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallApplicationRule;
        });
    }
}
