// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AzureWebCategoryInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListAzureWebCategories API service call.
 */
@Fluent
public final class AzureWebCategoryListResult implements JsonSerializable<AzureWebCategoryListResult> {
    /*
     * List of Azure Web Categories for a given Subscription.
     */
    private List<AzureWebCategoryInner> value;

    /*
     * URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of AzureWebCategoryListResult class.
     */
    public AzureWebCategoryListResult() {
    }

    /**
     * Get the value property: List of Azure Web Categories for a given Subscription.
     * 
     * @return the value value.
     */
    public List<AzureWebCategoryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Azure Web Categories for a given Subscription.
     * 
     * @param value the value value to set.
     * @return the AzureWebCategoryListResult object itself.
     */
    public AzureWebCategoryListResult withValue(List<AzureWebCategoryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AzureWebCategoryListResult object itself.
     */
    public AzureWebCategoryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureWebCategoryListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureWebCategoryListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureWebCategoryListResult.
     */
    public static AzureWebCategoryListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureWebCategoryListResult deserializedAzureWebCategoryListResult = new AzureWebCategoryListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AzureWebCategoryInner> value
                        = reader.readArray(reader1 -> AzureWebCategoryInner.fromJson(reader1));
                    deserializedAzureWebCategoryListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAzureWebCategoryListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureWebCategoryListResult;
        });
    }
}
