// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BastionShareableLinkInner;
import java.io.IOException;
import java.util.List;

/**
 * Post request for Create/Delete/Get Bastion Shareable Link endpoints.
 */
@Fluent
public final class BastionShareableLinkListRequest implements JsonSerializable<BastionShareableLinkListRequest> {
    /*
     * List of VM references.
     */
    private List<BastionShareableLinkInner> vms;

    /**
     * Creates an instance of BastionShareableLinkListRequest class.
     */
    public BastionShareableLinkListRequest() {
    }

    /**
     * Get the vms property: List of VM references.
     * 
     * @return the vms value.
     */
    public List<BastionShareableLinkInner> vms() {
        return this.vms;
    }

    /**
     * Set the vms property: List of VM references.
     * 
     * @param vms the vms value to set.
     * @return the BastionShareableLinkListRequest object itself.
     */
    public BastionShareableLinkListRequest withVms(List<BastionShareableLinkInner> vms) {
        this.vms = vms;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vms() != null) {
            vms().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vms", this.vms, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BastionShareableLinkListRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BastionShareableLinkListRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BastionShareableLinkListRequest.
     */
    public static BastionShareableLinkListRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BastionShareableLinkListRequest deserializedBastionShareableLinkListRequest
                = new BastionShareableLinkListRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vms".equals(fieldName)) {
                    List<BastionShareableLinkInner> vms
                        = reader.readArray(reader1 -> BastionShareableLinkInner.fromJson(reader1));
                    deserializedBastionShareableLinkListRequest.vms = vms;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBastionShareableLinkListRequest;
        });
    }
}
