// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the destination of connection monitor.
 */
@Fluent
public final class ConnectionMonitorDestination implements JsonSerializable<ConnectionMonitorDestination> {
    /*
     * The ID of the resource used as the destination by connection monitor.
     */
    private String resourceId;

    /*
     * Address of the connection monitor destination (IP or domain name).
     */
    private String address;

    /*
     * The destination port used by connection monitor.
     */
    private Integer port;

    /**
     * Creates an instance of ConnectionMonitorDestination class.
     */
    public ConnectionMonitorDestination() {
    }

    /**
     * Get the resourceId property: The ID of the resource used as the destination by connection monitor.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The ID of the resource used as the destination by connection monitor.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ConnectionMonitorDestination object itself.
     */
    public ConnectionMonitorDestination withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the address property: Address of the connection monitor destination (IP or domain name).
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: Address of the connection monitor destination (IP or domain name).
     * 
     * @param address the address value to set.
     * @return the ConnectionMonitorDestination object itself.
     */
    public ConnectionMonitorDestination withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the port property: The destination port used by connection monitor.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The destination port used by connection monitor.
     * 
     * @param port the port value to set.
     * @return the ConnectionMonitorDestination object itself.
     */
    public ConnectionMonitorDestination withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeNumberField("port", this.port);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorDestination if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorDestination.
     */
    public static ConnectionMonitorDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorDestination deserializedConnectionMonitorDestination = new ConnectionMonitorDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedConnectionMonitorDestination.resourceId = reader.getString();
                } else if ("address".equals(fieldName)) {
                    deserializedConnectionMonitorDestination.address = reader.getString();
                } else if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorDestination.port = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorDestination;
        });
    }
}
