// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the connection monitor test group.
 */
@Fluent
public final class ConnectionMonitorTestGroup implements JsonSerializable<ConnectionMonitorTestGroup> {
    /*
     * The name of the connection monitor test group.
     */
    private String name;

    /*
     * Value indicating whether test group is disabled.
     */
    private Boolean disable;

    /*
     * List of test configuration names.
     */
    private List<String> testConfigurations;

    /*
     * List of source endpoint names.
     */
    private List<String> sources;

    /*
     * List of destination endpoint names.
     */
    private List<String> destinations;

    /**
     * Creates an instance of ConnectionMonitorTestGroup class.
     */
    public ConnectionMonitorTestGroup() {
    }

    /**
     * Get the name property: The name of the connection monitor test group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the connection monitor test group.
     * 
     * @param name the name value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the disable property: Value indicating whether test group is disabled.
     * 
     * @return the disable value.
     */
    public Boolean disable() {
        return this.disable;
    }

    /**
     * Set the disable property: Value indicating whether test group is disabled.
     * 
     * @param disable the disable value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    /**
     * Get the testConfigurations property: List of test configuration names.
     * 
     * @return the testConfigurations value.
     */
    public List<String> testConfigurations() {
        return this.testConfigurations;
    }

    /**
     * Set the testConfigurations property: List of test configuration names.
     * 
     * @param testConfigurations the testConfigurations value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withTestConfigurations(List<String> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    /**
     * Get the sources property: List of source endpoint names.
     * 
     * @return the sources value.
     */
    public List<String> sources() {
        return this.sources;
    }

    /**
     * Set the sources property: List of source endpoint names.
     * 
     * @param sources the sources value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    /**
     * Get the destinations property: List of destination endpoint names.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of destination endpoint names.
     * 
     * @param destinations the destinations value to set.
     * @return the ConnectionMonitorTestGroup object itself.
     */
    public ConnectionMonitorTestGroup withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property name in model ConnectionMonitorTestGroup"));
        }
        if (testConfigurations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property testConfigurations in model ConnectionMonitorTestGroup"));
        }
        if (sources() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sources in model ConnectionMonitorTestGroup"));
        }
        if (destinations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinations in model ConnectionMonitorTestGroup"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorTestGroup.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("testConfigurations", this.testConfigurations,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disable", this.disable);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorTestGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorTestGroup if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectionMonitorTestGroup.
     */
    public static ConnectionMonitorTestGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorTestGroup deserializedConnectionMonitorTestGroup = new ConnectionMonitorTestGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorTestGroup.name = reader.getString();
                } else if ("testConfigurations".equals(fieldName)) {
                    List<String> testConfigurations = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectionMonitorTestGroup.testConfigurations = testConfigurations;
                } else if ("sources".equals(fieldName)) {
                    List<String> sources = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectionMonitorTestGroup.sources = sources;
                } else if ("destinations".equals(fieldName)) {
                    List<String> destinations = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectionMonitorTestGroup.destinations = destinations;
                } else if ("disable".equals(fieldName)) {
                    deserializedConnectionMonitorTestGroup.disable = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorTestGroup;
        });
    }
}
