// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the settings for producing output into a log analytics workspace.
 */
@Fluent
public final class ConnectionMonitorWorkspaceSettings implements JsonSerializable<ConnectionMonitorWorkspaceSettings> {
    /*
     * Log analytics workspace resource ID.
     */
    private String workspaceResourceId;

    /**
     * Creates an instance of ConnectionMonitorWorkspaceSettings class.
     */
    public ConnectionMonitorWorkspaceSettings() {
    }

    /**
     * Get the workspaceResourceId property: Log analytics workspace resource ID.
     * 
     * @return the workspaceResourceId value.
     */
    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    /**
     * Set the workspaceResourceId property: Log analytics workspace resource ID.
     * 
     * @param workspaceResourceId the workspaceResourceId value to set.
     * @return the ConnectionMonitorWorkspaceSettings object itself.
     */
    public ConnectionMonitorWorkspaceSettings withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceResourceId", this.workspaceResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorWorkspaceSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorWorkspaceSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorWorkspaceSettings.
     */
    public static ConnectionMonitorWorkspaceSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorWorkspaceSettings deserializedConnectionMonitorWorkspaceSettings
                = new ConnectionMonitorWorkspaceSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaceResourceId".equals(fieldName)) {
                    deserializedConnectionMonitorWorkspaceSettings.workspaceResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorWorkspaceSettings;
        });
    }
}
