// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters that determine how the connectivity check will be performed.
 */
@Fluent
public final class ConnectivityParameters implements JsonSerializable<ConnectivityParameters> {
    /*
     * The source of the connection.
     */
    private ConnectivitySource source;

    /*
     * The destination of connection.
     */
    private ConnectivityDestination destination;

    /*
     * Network protocol.
     */
    private Protocol protocol;

    /*
     * Configuration of the protocol.
     */
    private ProtocolConfiguration protocolConfiguration;

    /*
     * Preferred IP version of the connection.
     */
    private IpVersion preferredIpVersion;

    /**
     * Creates an instance of ConnectivityParameters class.
     */
    public ConnectivityParameters() {
    }

    /**
     * Get the source property: The source of the connection.
     * 
     * @return the source value.
     */
    public ConnectivitySource source() {
        return this.source;
    }

    /**
     * Set the source property: The source of the connection.
     * 
     * @param source the source value to set.
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withSource(ConnectivitySource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the destination property: The destination of connection.
     * 
     * @return the destination value.
     */
    public ConnectivityDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination property: The destination of connection.
     * 
     * @param destination the destination value to set.
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withDestination(ConnectivityDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the protocol property: Network protocol.
     * 
     * @return the protocol value.
     */
    public Protocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Network protocol.
     * 
     * @param protocol the protocol value to set.
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the protocolConfiguration property: Configuration of the protocol.
     * 
     * @return the protocolConfiguration value.
     */
    public ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    /**
     * Set the protocolConfiguration property: Configuration of the protocol.
     * 
     * @param protocolConfiguration the protocolConfiguration value to set.
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withProtocolConfiguration(ProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

    /**
     * Get the preferredIpVersion property: Preferred IP version of the connection.
     * 
     * @return the preferredIpVersion value.
     */
    public IpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    /**
     * Set the preferredIpVersion property: Preferred IP version of the connection.
     * 
     * @param preferredIpVersion the preferredIpVersion value to set.
     * @return the ConnectivityParameters object itself.
     */
    public ConnectivityParameters withPreferredIpVersion(IpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property source in model ConnectivityParameters"));
        } else {
            source().validate();
        }
        if (destination() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destination in model ConnectivityParameters"));
        } else {
            destination().validate();
        }
        if (protocolConfiguration() != null) {
            protocolConfiguration().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeJsonField("protocolConfiguration", this.protocolConfiguration);
        jsonWriter.writeStringField("preferredIPVersion",
            this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectivityParameters.
     */
    public static ConnectivityParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityParameters deserializedConnectivityParameters = new ConnectivityParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedConnectivityParameters.source = ConnectivitySource.fromJson(reader);
                } else if ("destination".equals(fieldName)) {
                    deserializedConnectivityParameters.destination = ConnectivityDestination.fromJson(reader);
                } else if ("protocol".equals(fieldName)) {
                    deserializedConnectivityParameters.protocol = Protocol.fromString(reader.getString());
                } else if ("protocolConfiguration".equals(fieldName)) {
                    deserializedConnectivityParameters.protocolConfiguration = ProtocolConfiguration.fromJson(reader);
                } else if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectivityParameters.preferredIpVersion = IpVersion.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityParameters;
        });
    }
}
